-- phpMyAdmin SQL Dump
-- version 5.2.3
-- https://www.phpmyadmin.net/
--
-- 호스트: infodb.ansan.ac.kr
-- 생성 시간: 25-12-04 14:53
-- 서버 버전: 12.0.2-MariaDB
-- PHP 버전: 8.3.6

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- 데이터베이스: `db2351013_ReadUS`
--

-- --------------------------------------------------------

--
-- 테이블 구조 `bookmarks`
--

CREATE TABLE `bookmarks` (
  `id` int(11) NOT NULL COMMENT '북마크 고유 ID',
  `user_id` int(11) NOT NULL COMMENT '북마크를 등록한 사용자 ID',
  `book_id` int(11) NOT NULL COMMENT '북마크가 속한 도서 ID',
  `page_number` int(11) DEFAULT NULL COMMENT '북마크한 페이지 번호',
  `note` text DEFAULT NULL COMMENT '북마크에 대한 간단한 메모',
  `created_at` datetime DEFAULT current_timestamp() COMMENT '북마크 생성 일시',
  `page` int(11) DEFAULT NULL COMMENT '추가 페이지 정보',
  `memo` text DEFAULT NULL COMMENT '추가 메모'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `bookmarks`
--

INSERT INTO `bookmarks` (`id`, `user_id`, `book_id`, `page_number`, `note`, `created_at`, `page`, `memo`) VALUES
(18, 41, 71, NULL, NULL, '2025-09-24 15:51:09', 8, '중요!! 기억하기!! 시험에 필수로 나옴!!'),
(19, 43, 70, NULL, NULL, '2025-10-01 14:23:59', 5, '중요함');

-- --------------------------------------------------------

--
-- 테이블 구조 `books`
--

CREATE TABLE `books` (
  `id` int(11) NOT NULL COMMENT '각 책의 고유 ID (자동증가)',
  `title` varchar(255) NOT NULL COMMENT '책 제목',
  `category` varchar(100) DEFAULT NULL COMMENT '도서 카테고리 (예: 소설, 에세이 등)',
  `cover_image` varchar(255) DEFAULT NULL COMMENT '책 표지 이미지 파일 경로 (예: img/cover1.jpg)',
  `description` text DEFAULT NULL COMMENT '책 상세 설명 또는 요약',
  `created_at` datetime DEFAULT current_timestamp() COMMENT '레코드 생성 일시',
  `category_id` int(11) DEFAULT NULL COMMENT 'categories 테이블의 id 참조 (어떤 카테고리 소속인지)',
  `author` varchar(255) DEFAULT NULL COMMENT '저자 이름',
  `publisher` varchar(255) DEFAULT NULL COMMENT '출판사 이름',
  `published_date` date DEFAULT NULL COMMENT '출간일 (YYYY-MM-DD)',
  `price` int(11) DEFAULT NULL COMMENT '가격 (원 단위)',
  `is_monthly_featured` tinyint(1) NOT NULL DEFAULT 0 COMMENT '이달의 책 여부 (1=이달의 책,0=일반)'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `books`
--

INSERT INTO `books` (`id`, `title`, `category`, `cover_image`, `description`, `created_at`, `category_id`, `author`, `publisher`, `published_date`, `price`, `is_monthly_featured`) VALUES
(69, '현명한 투자자', NULL, 'n1-2.png', '재정적 자유를 얻는 방법과 자산을 늘리는 법을 다룬 책입니다. 금융 교육의 중요성을 알려주며, 누구나 실천할 수 있는 실용적인 조언을 제공합니다.', '2025-05-13 17:27:58', 1, '로버트 기요사키(지은이), 안진환(옮긴이)', '국일증권경제연구소', '2020-05-00', 17000, 0),
(70, 'PHP로 작성하는 웹 프로그래밍 기초', NULL, 'n2-2.png', 'PHP를 사용한 웹 프로그래밍의 기초부터 실습을 통해 이해할 수 있는 좋은 입문서입니다. 초보자에게 적합하며, 코드 예제와 함께 설명이 잘 되어있어 실용적입니다.', '2025-05-13 17:30:37', 2, '오윤상 , 김두상 , 김영천 저자(글)', '기한재', '2024-11-25', 26000, 0),
(71, '2025 시나공 정보처리기사 필기 기본서', NULL, 'n2-1.png', '정보처리기사 필기 시험 준비에 필요한 핵심 내용을 잘 정리한 기본서입니다. 처음 공부하는 사람도 이해하기 쉽고, 다양한 예제와 문제풀이가 실용적입니다.', '2025-05-13 17:30:49', 2, '길벗 R&D, 강윤석, 김용갑, 김우경, 김종일, 김정준(지은이)', '길벗', '2024-11-00', 23000, 0),
(73, '모든 날에 모든 순간에 위로를 보낸다', NULL, 'n3-1.png', '일상에서 느낄 수 있는 작은 위로의 순간들을 담고 있어, 마음에 깊은 위안을 주는 작품입니다. 삶의 소소한 기쁨을 되새기며 마음의 평화를 얻을 수 있는 책 입니다.', '2025-05-13 17:31:49', 3, '글배우(지은이)', '강한별', '2021-04-00', 23000, 0),
(74, '부자 아빠 가난한 아빠', NULL, 'n1-1.png', '이 책이 가르쳐주는 투자 전략은 바로 \'가치있는 종목\'을 골라 수익을 올리는 가치투자입니다. 가치있는 종목을 어떻게 선별하고, 이를 위해 어떤 원칙을 준수해야 하는지 알려주는 것입니다.', '2025-05-13 17:34:19', 1, '벤저민 그레이엄(지은이), 이건(옮긴이), 신진오(감수)', '믿음인', '2018-02-00', 23000, 0),
(75, '좋은 일이 오려고 그러나 보다', NULL, 'n3-2.png', '인생에 긍정적인 변화를 가져오고 싶을 때 읽으면 좋은 책 입니다. 힘든 시기에 위로와 희망을 주는 메시지가 담겨 있고, 간결하고 감동적인 이야기들이 일상의 작은 행복을 되돌아보게 합니다.', '2025-05-13 23:27:34', 3, '박여름(지은이)', '히읏', '2023-07-00', 16800, 0),
(77, '화장품 브랜드가 말해주지 않는 것들', NULL, 'cover1.jpg', '성공이 지속 가능하려면 어떤 비전과 혁신이 필요할까요? 이 질문에 대한 해답을 찾는 이들에게 <화장품 브랜드에서 알려주지 않는 것들>\r\n은 훌륭한 나침반이 되어 줄 것입니다', '2025-05-14 00:06:53', 4, '이서진', 'OHK', '2025-03-04', 16650, 0),
(78, 'K-뷰티 탐미:다섯가지 힘', NULL, 'cover2.jpg', '이 책은 아줌마의 열정, 치열한 생존 본능, 자연에서 얻은 지혜, 손끝의 정교함, 그리고 한류의 영향력까지, K-뷰티의 숨겨진 비밀과 성공의 원동력을 심층적으로 파헤친다.\r\n', '2025-05-14 00:10:09', 4, '고병수', '좋은땅', '2025-02-20', 15300, 0),
(80, '백년운동', NULL, 'cover3.jpg', '서울대 의대 재활의학과 정선근 교수가 새로운 책,‘백년운동’을 통해서 100세 인생을 건강하고 멋지게 살고 싶은 이들에게 그 방법을 의학적으로 제시한다. 건강분야 스테디셀러인‘ 백년허리’,‘백년 목’이 허리와 목디스크 질환에 대한 새로운 치료법을 대중에게 제시한 책이라면,‘백년운동’은 관절과 척추를 보호하면서 안전하게 운동할 수 있는 운동방법을 제시한 책이다.', '2025-05-14 00:18:39', 5, '정선근', '아티잔', '2019-10-31', 17550, 0),
(81, '저속노화 식사법', NULL, 'cover4.jpg', '여러 매체를 통해 가속 노화의 위험을 알리며, 전 국민에게 저속 노화 열풍을 일으킨 정희원 교수의 느리게 나이 드는 식습관 완결판 책이 드디어 출간됐다. 저자는 SNS를 통해 한 숟갈씩 떠먹여 주듯 실제 도움이 될 만한 건강 정보를 지속적으로 전하며, 건강한 삶에 대한 다양한 연령대의 갈증을 해소해 주었고, 지금은 전 국민의 건강 커뮤니티 형성에 이바지하고 있다.', '2025-05-14 00:21:03', 5, '정희원', '테이스트북스', '2024-07-26', 17100, 0),
(82, '사카모토 데이즈 20:보금자리', NULL, 'cover5.jpg', '일본 현지 발행 누계 800만 부를 돌파한 인기 만화', '2025-05-14 00:24:39', 6, 'Yuto Suzuki', '대원씨아이', '2025-03-31', 5850, 0),
(83, '마루는 강쥐 6', NULL, 'cover6.jpg', '언니와 난생 처음 오래 떨어지게 된 마루! 그것도 두 밤이나 기다려야 한다고?! 하지만 어쩐 일인지, 마루는 언니가 집으로 돌아오지 않을 것이라고 확신하는데….눈물 없이는 볼 수 없는 마루의 이야기부터, 기억력이 조금(?) 나쁜 햄스터 뽀미의 집을 찾아줘야만 하는 마루까지! 단서라고는 알아볼 수 없는 모양이 그려진 그림뿐인데…. 어라? 이 모양은…?\r\n', '2025-05-14 00:25:59', 6, '모죠', '문페이스', '2025-03-27', 14400, 0),
(94, '장터', NULL, 'img/Fair.jpg', NULL, '2025-05-21 00:48:55', NULL, NULL, NULL, NULL, NULL, 1),
(95, '레오', NULL, 'img/Reo.jpg', NULL, '2025-05-21 00:49:04', NULL, NULL, NULL, NULL, NULL, 1),
(96, '푸름', NULL, 'img/Blueness.jpg', NULL, '2025-05-21 00:49:17', NULL, NULL, NULL, NULL, NULL, 1),
(97, '괜찮지 않은데 괜찮은 척 했다', NULL, 'img/6835ce56243c6_IMG_1803.jpeg', NULL, '2025-05-27 23:38:14', NULL, NULL, NULL, NULL, NULL, 1),
(98, '참 애썼다 그것으로 되었다', NULL, 'img/6835d035debda_IMG_1804.jpeg', NULL, '2025-05-27 23:46:13', NULL, NULL, NULL, NULL, NULL, 1),
(100, '빅 사이클', NULL, 'img/684103e45dce4_비즈니스 클럽.jpg', NULL, '2025-06-05 11:41:40', NULL, NULL, NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- 테이블 구조 `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL COMMENT '카테고리 고유 ID',
  `name` varchar(100) DEFAULT NULL COMMENT '카테고리 이름',
  `category_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `categories`
--

INSERT INTO `categories` (`id`, `name`, `category_id`) VALUES
(1, '경제 / 투자', NULL),
(2, 'IT / 프로그래밍', NULL),
(3, '에세이', NULL),
(4, '패션 / 뷰티', NULL),
(5, '건강 / 운동', NULL),
(6, '만화 / 웹툰', NULL);

-- --------------------------------------------------------

--
-- 테이블 구조 `friends`
--

CREATE TABLE `friends` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT '친구 관계 요청자(사용자) ID',
  `friend_id` int(11) DEFAULT NULL COMMENT '친구로 추가된 사용자 ID',
  `created_at` datetime DEFAULT NULL COMMENT '친구 관계 생성 일시'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `friends`
--

INSERT INTO `friends` (`id`, `user_id`, `friend_id`, `created_at`) VALUES
(24, 30, 28, '2025-06-06 09:59:22'),
(25, 28, 30, '2025-06-06 09:59:22'),
(28, 37, 36, '2025-08-27 12:36:56'),
(29, 36, 37, '2025-08-27 12:36:56'),
(36, 43, 24, '2025-10-01 14:22:51'),
(37, 24, 43, '2025-10-01 14:22:51');

-- --------------------------------------------------------

--
-- 테이블 구조 `friend_requests`
--

CREATE TABLE `friend_requests` (
  `id` int(11) NOT NULL COMMENT '친구 요청 고유 ID',
  `sender_id` int(11) NOT NULL COMMENT '친구 요청을 보낸 사용자 ID',
  `receiver_id` int(11) NOT NULL COMMENT '친구 요청을 받은 사용자 ID',
  `status` enum('pending','accepted','rejected') DEFAULT 'pending' COMMENT '친구 요청 상태',
  `requested_at` datetime DEFAULT current_timestamp() COMMENT '요청을 보낸 시각',
  `created_at` datetime DEFAULT current_timestamp() COMMENT '레코드 생성 시각'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `friend_requests`
--

INSERT INTO `friend_requests` (`id`, `sender_id`, `receiver_id`, `status`, `requested_at`, `created_at`) VALUES
(1, 1, 2, 'pending', '2025-05-26 00:51:53', '2025-05-26 21:41:44'),
(2, 1, 2, 'pending', '2025-05-26 00:52:12', '2025-05-26 21:41:44'),
(3, 31, 25, 'accepted', '2025-05-26 01:15:20', '2025-05-26 21:41:44'),
(4, 31, 25, 'accepted', '2025-05-26 01:17:47', '2025-05-26 21:41:44'),
(5, 31, 25, 'accepted', '2025-05-26 01:19:07', '2025-05-26 21:41:44'),
(17, 25, 31, 'accepted', '2025-05-27 12:01:37', '2025-05-27 12:01:37'),
(18, 26, 31, 'accepted', '2025-05-28 21:39:49', '2025-05-28 21:39:49'),
(19, 28, 30, 'rejected', '2025-06-06 07:37:12', '2025-06-06 07:37:12'),
(20, 30, 28, 'accepted', '2025-06-06 07:43:29', '2025-06-06 07:43:29'),
(21, 32, 33, 'accepted', '2025-06-09 00:24:10', '2025-06-09 00:24:10'),
(22, 34, 33, 'pending', '2025-06-09 00:25:38', '2025-06-09 00:25:38'),
(23, 37, 36, 'accepted', '2025-08-27 11:31:18', '2025-08-27 11:31:18'),
(27, 43, 24, 'accepted', '2025-10-01 14:22:50', '2025-10-01 14:22:50');

-- --------------------------------------------------------

--
-- 테이블 구조 `recommendations`
--

CREATE TABLE `recommendations` (
  `id` int(11) NOT NULL,
  `receiver_id` int(11) DEFAULT NULL COMMENT '도서를 추천받은 사용자 ID',
  `book_id` int(11) DEFAULT NULL COMMENT '추천한 도서 ID',
  `message` text DEFAULT NULL COMMENT '추천 할 때 남긴 메시지',
  `created_at` datetime DEFAULT NULL COMMENT '추천 생성 일시',
  `from_user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `recommendations`
--

INSERT INTO `recommendations` (`id`, `receiver_id`, `book_id`, `message`, `created_at`, `from_user_id`) VALUES
(7, 37, 69, '읽어봐 투자 좀 하자 같이', '2025-09-10 14:28:29', 36),
(8, 24, 70, '공부 열심히 하장', '2025-09-24 15:09:09', 39);

-- --------------------------------------------------------

--
-- 테이블 구조 `reviews`
--

CREATE TABLE `reviews` (
  `id` int(11) NOT NULL COMMENT '리뷰 고유 ID',
  `user_id` int(11) NOT NULL COMMENT '리뷰 작성자 ID',
  `book_id` int(11) NOT NULL COMMENT '리뷰 대상 도서 ID',
  `rating` tinyint(4) NOT NULL COMMENT '도서에 대한 평점 (1~5)',
  `content` text DEFAULT NULL COMMENT '리뷰 본문 내용',
  `created_at` datetime DEFAULT current_timestamp() COMMENT '리뷰 작성 일시',
  `review` text DEFAULT NULL COMMENT '리뷰 내용'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `reviews`
--

INSERT INTO `reviews` (`id`, `user_id`, `book_id`, `rating`, `content`, `created_at`, `review`) VALUES
(19, 33, 83, 5, '마루킁킁', '2025-06-03 20:41:30', NULL),
(34, 41, 71, 5, '공부하기 좋아요!!', '2025-09-24 15:50:48', NULL),
(35, 43, 70, 5, '공부하기 좋다', '2025-10-01 14:24:12', NULL);

-- --------------------------------------------------------

--
-- 테이블 구조 `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(100) DEFAULT NULL COMMENT '사용자 로그인용 아이디',
  `password` varchar(255) DEFAULT NULL COMMENT '사용자 비밀번호',
  `email` varchar(255) DEFAULT NULL COMMENT '사용자 이메일 주소',
  `nickname` varchar(100) DEFAULT NULL COMMENT '사용자 닉네임',
  `created_at` datetime DEFAULT NULL COMMENT '사용자 가입 일시'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `email`, `nickname`, `created_at`) VALUES
(14, 'minju0507', '$2y$10$5yJsq7TonEKmMRnuWjejc.gCNHM8SIB2z6RGpiP0sip54LWhQqZaG', 'mnju91618@naver.com', NULL, NULL),
(15, 'kongyi', '$2y$10$IBtzVdEJZO.FC/97p3rg..5MNDAabUKNIikuQnhKyiqtWNAhTpRpK', 'sunwoowood1020@naver.com', NULL, NULL),
(17, 'gmltn0975', '$2y$10$1UAHE0.JfowQXjkQq2tHt.zeBSMOk6JA4UARlSsHXW7FjfVuMM85i', 'namein0103@gmail.com', NULL, NULL),
(24, '신유림', '$2y$10$rfx8TZbaFlBQF8VOvZKniuaFeKnTT90aUVJZzt.HXOFKFJYNDPScC', 'shinyourim@naver.com', NULL, NULL),
(27, 'qwer', '$2y$10$X72.kQjxnL0lcDe61Wug5OTZcknyaHz4QMw91ZEeExAuAYWN12QSq', 'qwer@naver.com', NULL, NULL),
(28, 'p0821y', '$2y$10$9nfnkv.Mb6mTDRHamANHruJG6YxSaP9E6UieG3UE/N5gxBHvOlX/O', 'pp0821pp@naver.com', NULL, NULL),
(30, 'qhdus', '$2y$10$y/6ap738HQyJvPKiRIzh7O0qIu7wPegvsBYpowW9VMnaADSur6m9G', 'p0821p@naver.com', NULL, NULL),
(33, '123', '$2y$10$asd2ldj1GV/zG5YX.dRbW.e/x93KMd1IbROwc21/G/AoMdtXVSrNm', '123@naver.com', NULL, NULL),
(34, 'tlsdbfla', '$2y$10$EQ0F9xoYC7QNYk4TKfvXBuKEwPyXgmkAdFofcLEQgVK5M/ahk03n.', 'qkqh@naver.com', NULL, NULL),
(35, 'helloworld', '$2y$10$vhPu0g6eE.PjQgg9iKwqr.8i7AHTjRGKqtdNJ7j7SAOY4J3H7zzBu', 'helloworld@ansan.com', NULL, NULL),
(36, '컴정과', '$2y$10$q9a07/qJLD6aryaPA047fOyhmQVVK4AxZSP/12B2V.wht7NBDn8Pi', 'zjWjxrhkfm@gmail.com', NULL, NULL),
(37, 'gkswjdgus', '$2y$10$o9I2Kp1s0jTZJP1.HbMjvOAFFHPSlvwpP9zO1qbgoSBtMcjb6aQVC', 'gkswjdgus@gmail.com', NULL, NULL),
(38, '일단하자', '$2y$10$bpY/H9iFaCH4o7sOorjkY.U8yPec35EvL7x1VX9Q4YLLSEm5fY5oy', 'qorwogus230@naver.com', NULL, NULL),
(41, '컴퓨터정보', '$2y$10$l9FouzZ67Z/Ibq2utEy6W.nMePv7d28Zndw7PIrtcldqeFVfFBAzq', 'zjavbxjwjdqgh@gmail.com', NULL, NULL),
(43, '컴퓨터정보학과', '$2y$10$PvNSaOZjEv7RoQiTPX4IAubqEadiNSH5wgEU1FixxsEhR.1NVo/4.', 'zjawjdrhk@gmail.com', NULL, NULL);

-- --------------------------------------------------------

--
-- 테이블 구조 `user_read_books`
--

CREATE TABLE `user_read_books` (
  `id` int(11) NOT NULL COMMENT '읽은 기록 고유 ID',
  `user_id` int(11) NOT NULL COMMENT '독서 기록의 사용자 ID',
  `book_id` int(11) NOT NULL COMMENT '읽은 도서의 ID',
  `read_date` date NOT NULL COMMENT '도서를 읽은 날짜'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- 테이블의 덤프 데이터 `user_read_books`
--

INSERT INTO `user_read_books` (`id`, `user_id`, `book_id`, `read_date`) VALUES
(26, 33, 83, '2025-06-03'),
(61, 30, 80, '2025-06-06'),
(62, 30, 81, '2025-06-06'),
(65, 41, 71, '2025-09-24'),
(66, 41, 70, '2025-09-24'),
(74, 28, 80, '2025-10-01'),
(75, 28, 81, '2025-10-01'),
(76, 28, 69, '2025-10-01'),
(78, 43, 70, '2025-10-01');

--
-- 덤프된 테이블의 인덱스
--

--
-- 테이블의 인덱스 `bookmarks`
--
ALTER TABLE `bookmarks`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `book_id` (`book_id`);

--
-- 테이블의 인덱스 `books`
--
ALTER TABLE `books`
  ADD PRIMARY KEY (`id`);

--
-- 테이블의 인덱스 `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`);

--
-- 테이블의 인덱스 `friends`
--
ALTER TABLE `friends`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `friend_id` (`friend_id`);

--
-- 테이블의 인덱스 `friend_requests`
--
ALTER TABLE `friend_requests`
  ADD PRIMARY KEY (`id`);

--
-- 테이블의 인덱스 `recommendations`
--
ALTER TABLE `recommendations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `receiver_id` (`receiver_id`),
  ADD KEY `book_id` (`book_id`);

--
-- 테이블의 인덱스 `reviews`
--
ALTER TABLE `reviews`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `book_id` (`book_id`);

--
-- 테이블의 인덱스 `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- 테이블의 인덱스 `user_read_books`
--
ALTER TABLE `user_read_books`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `book_id` (`book_id`);

--
-- 덤프된 테이블의 AUTO_INCREMENT
--

--
-- 테이블의 AUTO_INCREMENT `bookmarks`
--
ALTER TABLE `bookmarks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '북마크 고유 ID', AUTO_INCREMENT=20;

--
-- 테이블의 AUTO_INCREMENT `books`
--
ALTER TABLE `books`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '각 책의 고유 ID (자동증가)', AUTO_INCREMENT=105;

--
-- 테이블의 AUTO_INCREMENT `friends`
--
ALTER TABLE `friends`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;

--
-- 테이블의 AUTO_INCREMENT `friend_requests`
--
ALTER TABLE `friend_requests`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '친구 요청 고유 ID', AUTO_INCREMENT=28;

--
-- 테이블의 AUTO_INCREMENT `recommendations`
--
ALTER TABLE `recommendations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- 테이블의 AUTO_INCREMENT `reviews`
--
ALTER TABLE `reviews`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '리뷰 고유 ID', AUTO_INCREMENT=36;

--
-- 테이블의 AUTO_INCREMENT `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=44;

--
-- 테이블의 AUTO_INCREMENT `user_read_books`
--
ALTER TABLE `user_read_books`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '읽은 기록 고유 ID', AUTO_INCREMENT=79;

--
-- 덤프된 테이블의 제약사항
--

--
-- 테이블의 제약사항 `bookmarks`
--
ALTER TABLE `bookmarks`
  ADD CONSTRAINT `bookmarks_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `bookmarks_ibfk_2` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`);

--
-- 테이블의 제약사항 `friends`
--
ALTER TABLE `friends`
  ADD CONSTRAINT `friends_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `friends_ibfk_2` FOREIGN KEY (`friend_id`) REFERENCES `users` (`id`);

--
-- 테이블의 제약사항 `recommendations`
--
ALTER TABLE `recommendations`
  ADD CONSTRAINT `recommendations_ibfk_2` FOREIGN KEY (`receiver_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `recommendations_ibfk_3` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`);

--
-- 테이블의 제약사항 `reviews`
--
ALTER TABLE `reviews`
  ADD CONSTRAINT `reviews_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `reviews_ibfk_2` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`);

--
-- 테이블의 제약사항 `user_read_books`
--
ALTER TABLE `user_read_books`
  ADD CONSTRAINT `user_read_books_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `user_read_books_ibfk_2` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
