<?php
session_start();  // 세션 시작 (로그인 상태 유지 등 위해 필요)

// 데이터베이스 접속 정보 설정
$host = "infodb.ansan.ac.kr";
$username = "i2351013";
$password = "tlsdbfla";
$dbname = "db2351013_ReadUS";

// MySQLi를 사용해 데이터베이스 연결 시도
$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);  // 연결 실패 시 오류 메시지 출력 후 종료
}

$error_message = "";   // 에러 메시지 초기화
$success_message = ""; // 성공 메시지 초기화
$redirect = false;     // 회원가입 성공 시 리다이렉트 여부 판단 변수

// 폼이 POST 방식으로 제출되었는지 확인
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 사용자 입력값 받아오기 (trim으로 공백 제거)
    $username_input = trim($_POST['username']);
    $email_input = trim($_POST['email']);
    $password_input = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];

    // 비밀번호와 비밀번호 확인 값이 같은지 체크
    if ($password_input !== $password_confirm) {
        $error_message = "❌ 비밀번호가 일치하지 않습니다.";  // 다르면 에러 메시지 설정
    } else {
        // 이메일 또는 아이디가 이미 존재하는지 DB에서 확인하기 위한 쿼리 준비
        $sql_check = "SELECT * FROM users WHERE email = ? OR username = ?";
        $stmt_check = $conn->prepare($sql_check);  // SQL 인젝션 방지를 위해 prepare 사용
        $stmt_check->bind_param("ss", $email_input, $username_input);  // 입력값 바인딩
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        // 결과가 1개 이상 있으면 중복된 아이디 또는 이메일이 있다는 뜻
        if ($result_check->num_rows > 0) {
            $error_message = "❌ 이메일 또는 아이디가 이미 존재합니다.";  // 중복 에러 메시지
        } else {
            // 비밀번호를 안전하게 암호화 (해시)
            $hashed_password = password_hash($password_input, PASSWORD_DEFAULT);

            // 새 사용자 데이터를 DB에 삽입하기 위한 쿼리 준비
            $sql_insert = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
            $stmt_insert = $conn->prepare($sql_insert);
            $stmt_insert->bind_param("sss", $username_input, $email_input, $hashed_password);

            // 쿼리 실행 결과에 따라 성공 또는 실패 메시지 설정
            if ($stmt_insert->execute()) {
                $success_message = "✅ 회원가입이 완료되었습니다! 잠시 후 로그인 페이지로 이동합니다.";
                $redirect = true;  // 성공 시 로그인 페이지로 리다이렉트 설정
            } else {
                $error_message = "❌ 회원가입에 실패했습니다. 다시 시도해주세요.";
            }

            $stmt_insert->close();  // 삽입 쿼리 닫기
        }
        $stmt_check->close();  // 중복 체크 쿼리 닫기
    }
}

$conn->close();  // DB 연결 종료
?>

<!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ReadUS 회원가입</title>
    <link rel="stylesheet" href="css/styles.css">

    <?php if ($redirect): ?>
        <!-- 회원가입 성공 시 3초 뒤 로그인 페이지로 자동 이동하는 스크립트 -->
        <script>
            setTimeout(function () {
                window.location.href = 'login.php';
            }, 3000);
        </script>
    <?php endif; ?>
</head>
<style>
    body {
        margin: 0 auto;
        font-family: Arial, sans-serif;
        background-color: #f3f4f6;
        width: 1280px;
    }
</style>
<body class="signup-page">
    <div class="auth-container">
        <div class="auth-logo"><a href="index.php">ReadUS</a></div>
        <div class="auth-header"><h2>회원가입</h2></div>

        <?php if ($error_message): ?>
            <!-- 에러 메시지 출력 -->
            <div class="error-message">
                <p><?= htmlspecialchars($error_message) ?></p>
            </div>
        <?php endif; ?>

        <?php if ($success_message): ?>
            <!-- 성공 메시지 출력 -->
            <div class="success-message">
                <p><?= htmlspecialchars($success_message) ?></p>
            </div>
        <?php endif; ?>

        <?php if (!$success_message): ?>
            <!-- 회원가입 폼 (성공 메시지가 없을 때만 보여줌) -->
            <form method="POST" action="signup.php">
                <div class="input-box">
                    <label for="username">ID</label>
                    <input type="text" id="username" name="username" placeholder="아이디 입력" required>
                </div>

                <div class="input-box">
                    <label for="email">이메일</label>
                    <input type="email" id="email" name="email" placeholder="이메일 입력" required>
                </div>

                <div class="input-box">
                    <label for="password">비밀번호</label>
                    <input type="password" id="password" name="password" placeholder="비밀번호 입력" required>
                </div>

                <div class="input-box">
                    <label for="password_confirm">비밀번호 확인</label>
                    <input type="password" id="password_confirm" name="password_confirm" placeholder="비밀번호 확인" required>
                </div>

                <button class="auth-btn" type="submit">회원가입</button>
                <div class="auth-footer"><a href="login.php">이미 계정이 있습니까? 로그인</a></div>
            </form>
        <?php endif; ?>
    </div>
</body>

</html>
