<?php
// GET 파라미터로 전달된 'payurl' 값을 가져오고, 값이 없으면 빈 문자열로 설정
$payUrl = $_GET['payurl'] ?? '';

// 'payurl'이 비어 있으면 잘못된 접근으로 간주하고 실행 중단
if (!$payUrl) exit('잘못된 접근');

// 구글 차트 API를 이용해 QR 코드 이미지를 생성
$qrImg = 'https://chart.googleapis.com/chart?cht=qr&chs=260x260&chl=' . urlencode($payUrl);
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="utf-8">
    <title>카카오페이 QR 결제</title>
</head>
<body>
    <h2>카카오페이로 결제해 주세요</h2>
    <p>휴대폰 카카오톡으로 아래 QR을 스캔하면 결제창이 열립니다.</p>

    <!-- 생성된 QR 코드 이미지를 출력 -->
    <img src="<?=$qrImg?>" alt="카카오페이 QR">
    <br><br>

    <!-- 데스크탑 환경에서도 직접 결제창을 열 수 있도록 링크 제공 -->
    <a href="<?=$payUrl?>" target="_blank">👉 PC에서도 결제창 열기</a>
</body>
</html>
