<?php
// 세션 시작 (사용자 로그인 상태 확인 등에 필요)
session_start();

// 데이터베이스 연결 파일 포함
include('db.php');

// GET 요청으로부터 검색어(q) 파라미터를 받아 trimming (공백 제거)
$searchQuery = isset($_GET['q']) ? trim($_GET['q']) : '';

// 검색 결과를 저장할 배열 초기화
$results = [];

// 검색어가 비어 있지 않은 경우에만 DB 검색 수행
if (!empty($searchQuery)) {
    // 책 제목에서 검색어를 포함하는 항목들을 가져오는 SQL 쿼리 준비
    $stmt = $conn->prepare("
        SELECT b.*, c.name AS category_name
        FROM books b
        JOIN categories c ON b.category_id = c.id
        WHERE b.title LIKE CONCAT('%', ?, '%')
    ");

    // 검색어를 바인딩하여 SQL 인젝션 방지
    $stmt->bind_param("s", $searchQuery);

    // 쿼리 실행
    $stmt->execute();

    // 실행 결과를 받아옴
    $result = $stmt->get_result();

    // 결과를 배열에 저장
    while ($row = $result->fetch_assoc()) {
        $results[] = $row;
    }

    // 준비한 쿼리 종료
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8" />
    <title>검색창창</title>
    <!-- 외부 CSS 스타일시트 연결 -->
    <link rel="stylesheet" href="css/styles.css" />
</head>

<!-- 인라인 스타일 정의 -->
<style>
    body {
        margin: 0 auto;
        font-family: Arial, sans-serif;
        background-color: #f3f4f6;
        width: 1280px;
    }
</style>

<body>
    <!-- 상단 헤더 섹션 -->
    <div class="header page-section">
        <!-- 로고 -->
        <div class="logo">
            <a href="index.php">ReadUS</a>
        </div>

        <!-- 검색바 -->
        <div class="search-bar">
            <form action="search.php" method="GET">
                <input type="text" name="q" placeholder="도서를 검색하세요!" required />
                <button type="submit" class="search-btn">검색</button>
            </form>
        </div>

        <!-- 로그인 여부에 따른 메뉴 -->
        <div class="menu">
            <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                <!-- 로그인된 사용자 정보 및 메뉴 -->
                <span class="welcome-message"><?php echo htmlspecialchars($_SESSION['username']); ?>님</span>
                <a href="edit-profile.php" title="회원정보 수정">⚙️</a>
                <a href="logout.php" title="로그아웃">🚪</a>
                <a href="mypage.php" title="MyPage">📚</a>
                <a href="wishlist.php" title="보관함">💖</a>
                <a href="cart.php" title="장바구니">🛒</a>
            <?php else: ?>
                <!-- 비로그인 사용자용 메뉴 -->
                <a href="login.php" title="로그인">🔐</a>
                <a href="signup.php" title="회원가입">👤</a>
            <?php endif; ?>
        </div>
    </div>

    <!-- 검색 결과 헤더 -->
    <h2 class="page-section">🔍 "<?php echo htmlspecialchars($searchQuery); ?>" 검색 결과</h2>
    <div class="underline"></div>

    <!-- 검색 결과 출력 영역 -->
    <div class="search-results page-section">
        <?php if (empty($results)): ?>
            <!-- 검색 결과가 없을 때 -->
            <p>검색 결과가 없습니다.</p>
        <?php else: ?>
            <!-- 검색 결과가 있을 때 각 도서를 출력 -->
            <?php foreach ($results as $book): ?>
                <?php
                // 책 표지 이미지 경로 설정 (없으면 기본 이미지 사용)
                $imgPath = !empty($book['cover_image'])
                    ? 'img/' . htmlspecialchars($book['cover_image'])
                    : 'img/default-book-cover.jpg';

                // 카테고리 이름 URL 인코딩 (카테고리 페이지로 이동할 수 있도록)
                $categoryNameUrl = urlencode($book['category_name']);
                ?>
                <!-- 개별 도서 카드 링크 -->
                <a href="category.php?name=<?php echo $categoryNameUrl; ?>" class="book-card-link">
                    <div class="book-card">
                        <img src="<?php echo $imgPath; ?>" alt="책 표지" />
                        <div class="book-title"><?php echo htmlspecialchars($book['title']); ?></div>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</body>
</html>
