<?php
session_start(); // 세션 시작
include('db.php'); // DB 연결 파일 포함
header('Content-Type: application/json; charset=utf-8'); // JSON 형식으로 응답을 보내도록 설정

// 로그인 여부 확인
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => '로그인이 필요합니다.']);
    exit;
}

$userId = (int)$_SESSION['user_id']; // 현재 로그인한 사용자 ID를 정수로 변환하여 저장

// 필수 POST 데이터가 전달되지 않은 경우
if (!isset($_POST['request_id'], $_POST['action'])) {
    echo json_encode(['success' => false, 'message' => '잘못된 요청입니다.']);
    exit;
}

$requestId = (int)$_POST['request_id']; // 요청 ID를 정수로 변환하여 저장
$action = $_POST['action']; // 처리할 작업 (accept 또는 reject)

// 해당 요청이 현재 사용자에게 온 '대기 중' 친구 요청인지 확인
$sql = "SELECT * FROM friend_requests WHERE id = $requestId AND receiver_id = $userId AND status = 'pending'";
$result = $conn->query($sql);

// 친구 요청이 존재하지 않거나 쿼리 실패 시
if ($result === false || $result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => '처리할 친구 요청이 없습니다.']);
    exit;
}

$row = $result->fetch_assoc(); // 요청 정보 가져오기
$senderId = $row['sender_id']; // 요청 보낸 사람의 ID 저장

// 친구 요청 수락 처리
if ($action === 'accept') {
    // 요청 상태를 'accepted'로 업데이트
    $updateSql = "UPDATE friend_requests SET status = 'accepted' WHERE id = $requestId";
    if (!$conn->query($updateSql)) {
        echo json_encode(['success' => false, 'message' => '상태 업데이트 실패']);
        exit;
    }

    // 친구 관계가 이미 존재하지 않는 경우에만 추가
    $checkSql = "SELECT 1 FROM friends WHERE user_id = $senderId AND friend_id = $userId";
    $checkResult = $conn->query($checkSql);
    if ($checkResult->num_rows === 0) {
        $now = date('Y-m-d H:i:s'); // 현재 시간 저장
        // 양방향 친구 관계 저장
        $conn->query("INSERT INTO friends (user_id, friend_id, created_at) VALUES ($senderId, $userId, '$now')");
        $conn->query("INSERT INTO friends (user_id, friend_id, created_at) VALUES ($userId, $senderId, '$now')");
    }

    // 성공 메시지 응답
    echo json_encode(['success' => true, 'message' => '친구 요청을 수락했습니다.', 'request_id' => $requestId]);

// 친구 요청 거절 처리
} elseif ($action === 'reject') {
    // 요청 상태를 'rejected'로 업데이트
    $conn->query("UPDATE friend_requests SET status = 'rejected' WHERE id = $requestId");

    // 성공 메시지 응답
    echo json_encode(['success' => true, 'message' => '친구 요청을 거절했습니다.', 'request_id' => $requestId]);

// 알 수 없는 작업일 경우
} else {
    echo json_encode(['success' => false, 'message' => '올바르지 않은 작업입니다.']);
}
?>
