<?php
session_start(); // 세션 시작
include('db.php'); // 데이터베이스 연결

// 로그인 여부 확인
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php'); // 로그인 안 되어 있으면 로그인 페이지로 이동
    exit();
}

// 결제 후 메시지를 flash 형태로 받아오기
$flashMessage = $_SESSION['flash_message'] ?? '';
unset($_SESSION['flash_message']); // 메시지 한번 보여주고 삭제

// 결제 직전 저장된 주문 정보 세션이 없다면 메시지 출력
if (!isset($_SESSION['last_order']) || empty($_SESSION['last_order'])) {
    echo "최근 주문 내역이 없습니다.";
    exit();
}

// 세션에서 주문 정보 가져오기
$order = $_SESSION['last_order'];

$orderId = $order['order_id']; // 주문 번호
$paymentDate = $order['payment_date']; // 결제 일시
$items = $order['items']; // 주문한 상품 목록
$totalPrice = $order['total_price']; // 총 결제 금액
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8" />
    <title>구매 영수증 - ReadUS</title>
    <style>
        /* 전체 페이지 스타일 설정 */
        body {
            margin: 0 auto;
            font-family: Arial, sans-serif;
            background-color: #f3f4f6;
            width: 1280px;
        }

        h1 {
            color: #000000;
            border-bottom: 3px solid #000000;
            padding-bottom: 10px;
            margin-bottom: 30px;
        }

        /* 결제 완료 flash 메시지 스타일 */
        .flash-message {
            background: #d4edda;
            color: #155724;
            padding: 15px 20px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            font-weight: 600;
            text-align: center;
        }

        /* 주문 및 고객 정보 박스 스타일 */
        .order-info, .customer-info {
            background: #fff;
            padding: 20px 25px;
            margin-bottom: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .order-info p, .customer-info p {
            font-size: 1.1rem;
            margin: 6px 0;
        }

        .customer-info h2 {
            margin-top: 0;
            color: #a499f2;
            border-bottom: 2px solid #a499f2;
            padding-bottom: 8px;
        }

        /* 주문 목록 테이블 스타일 */
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 12px;
            background: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border-radius: 10px;
        }

        thead th {
            background: #a499f2;
            color: #fff;
            padding: 14px 10px;
            font-weight: 700;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }

        tbody tr {
            background: #f0f4f8;
        }

        tbody td {
            padding: 14px 10px;
            font-size: 1rem;
            color: #333;
        }

        tfoot td {
            padding: 14px 10px;
            font-weight: 700;
            font-size: 1.15rem;
            text-align: right;
            color: #222;
        }

        tfoot td:first-child {
            text-align: right;
            padding-right: 15px;
        }

        /* 푸터 링크 스타일 */
        .footer-links {
            margin-top: 35px;
            text-align: center;
        }

        .footer-links a {
            color: #a499f2;
            text-decoration: none;
            font-weight: 600;
            margin: 0 15px;
            transition: color 0.3s ease;
        }

        .footer-links a:hover {
            color: #a499f2;
        }
    </style>
</head>

<body>
    <h1>구매 영수증</h1>

    <!-- flash 메시지 출력 -->
    <?php if ($flashMessage): ?>
        <div class="flash-message"><?= htmlspecialchars($flashMessage) ?></div>
    <?php endif; ?>

    <!-- 주문 기본 정보 출력 -->
    <p>주문번호: <strong><?= htmlspecialchars($orderId) ?></strong></p>
    <p>결제 일시: <strong><?= htmlspecialchars($paymentDate) ?></strong></p>

    <!-- 고객 정보 출력 -->
    <h2>고객 정보</h2>
    <p>이름: <strong><?= htmlspecialchars($order['customer_name']) ?></strong></p>
    <p>전화번호: <strong><?= htmlspecialchars($order['customer_phone']) ?></strong></p>
    <p>주소: <strong><?= htmlspecialchars($order['customer_address']) ?></strong></p>

    <!-- 결제 수단 출력 -->
    <p>결제수단: <strong>
        <?php
        // 결제수단 코드 → 한글로 출력
        $methods = [
            'card' => '신용/체크카드',
            'bank' => '계좌이체',
            'phone' => '휴대폰 결제'
        ];
        echo $methods[$order['payment_method']] ?? '알 수 없음';
        ?>
    </strong></p>

    <!-- 상품 목록 테이블 -->
    <table>
        <thead>
            <tr>
                <th>도서명</th>
                <th>수량</th>
                <th>단가(원)</th>
                <th>합계(원)</th>
            </tr>
        </thead>
        <tbody>
       <?php foreach ($items as $item): ?> <!-- 주문한 각 도서 정보를 반복 출력 -->
    <tr>
        <td><?= htmlspecialchars($item['title']) ?></td> <!-- 도서명 출력 -->
        <td><?= (int) $item['quantity'] ?></td> <!-- 수량 출력 (정수형으로 변환) -->
        <td><?= number_format($item['price']) ?></td> <!-- 단가 출력 (3자리마다 쉼표) -->
        <td><?= number_format($item['price'] * $item['quantity']) ?></td> <!-- 합계 출력 (단가 * 수량) -->
    </tr>
<?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="3" style="text-align:right; font-weight:bold;">총 결제금액:</td>
                <td style="font-weight:bold;"><?= number_format($totalPrice) ?> 원</td>
            </tr>
        </tfoot>
    </table>

    <!-- 홈으로 돌아가기 링크 -->
    <div style="margin-top: 30px;">
        <a href="index.php">ReadUS</a> |
    </div>
</body>
</html>
