<?php
session_start();

// DB 연결 설정
$host = "infodb.ansan.ac.kr";      // 데이터베이스 호스트 주소
$username = "i2351013";             // 데이터베이스 사용자명
$password = "tlsdbfla";             // 데이터베이스 비밀번호
$dbname = "db2351013_ReadUS";      // 사용할 데이터베이스 이름

// MySQLi로 DB 연결 시도
$conn = new mysqli($host, $username, $password, $dbname);

// 연결 실패 시 에러 메시지 출력 후 종료
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 로그인 처리 결과 메시지 변수 초기화
$error_message = "";
$success_message = "";
$redirect = false; // 로그인 성공 시 리다이렉트 여부

// POST 방식으로 데이터가 전달되었을 때만 로그인 처리
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username_input = $_POST['username']; // 사용자 입력한 아이디 또는 이메일
    $password_input = $_POST['password']; // 사용자 입력한 비밀번호

    // 이메일 또는 아이디가 일치하는 사용자를 검색하는 쿼리 준비
    $sql = "SELECT * FROM users WHERE email = ? OR username = ?";
    $stmt = $conn->prepare($sql);
    // 입력값을 바인딩 (이메일과 아이디 둘 다 같은 값 사용)
    $stmt->bind_param("ss", $username_input, $username_input);
    $stmt->execute();
    $result = $stmt->get_result();

    // 사용자 정보가 존재하는지 확인
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        // 비밀번호 해시와 비교하여 검증
        if (password_verify($password_input, $user['password'])) {
            // 로그인 성공 시 세션에 사용자 정보 저장
            $_SESSION['loggedin'] = true;
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['username'] = $user['username'];

            $success_message = "✅ 로그인 성공! 잠시 후 메인 페이지로 이동합니다.";
            $redirect = true; // 로그인 성공 시 리다이렉트 플래그 설정
        } else {
            // 비밀번호가 틀린 경우 에러 메시지 설정
            $error_message = "❌ 비밀번호가 잘못되었습니다.";
        }
    } else {
        // 해당 아이디 또는 이메일이 없는 경우 에러 메시지 설정
        $error_message = "❌ 아이디 또는 이메일이 존재하지 않습니다.";
    }

    $stmt->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ReadUS 로그인</title>
  <link rel="stylesheet" href="css/styles.css">
  <?php if ($redirect): ?>
    <script>
      // 로그인 성공 후 3초 뒤 index.php(메인 페이지)로 이동
      setTimeout(function(){
        window.location.href = 'index.php';
      }, 3000);
    </script>
  <?php endif; ?>
</head>
<style>
    body {
    margin: 0;
    font-family: Arial, sans-serif;
    background-color: #f3f4f6;
}

.container {
    width: 1280px;
    margin: 0 auto; /* 가로 가운데 정렬 */
    background-color: white; /* 필요시 배경색 지정 */
}

</style>
<body class="login-page">
<div class="auth-container">
  <div class="auth-logo"><a href="index.php">ReadUS</a></div>
  <div class="auth-header"><h2>로그인</h2></div>

  <!-- 에러 메시지가 있을 경우 출력 -->
  <?php if ($error_message): ?>
    <div class="error-message"><p><?= htmlspecialchars($error_message) ?></p></div>
  <?php endif; ?>

  <!-- 성공 메시지가 있을 경우 출력 -->
  <?php if ($success_message): ?>
    <div class="success-message"><p><?= htmlspecialchars($success_message) ?></p></div>
  <?php endif; ?>

  <!-- 로그인 성공 시 폼 숨기기 -->
  <?php if (!$success_message): ?>
    <form method="post" action="login.php">
      <div class="input-box">
        <label for="username">ID 또는 이메일</label>
        <input type="text" id="username" name="username" required>
      </div>
      <div class="input-box">
        <label for="password">비밀번호</label>
        <input type="password" id="password" name="password" required>
      </div>
      <button class="auth-btn" type="submit">로그인</button>
      <div class="auth-footer"><a href="signup.php">ReadUS회원가입</a></div>
    </form>
  <?php endif; ?>
</div> <!-- 모든 요소를 로그인 카드 안에 포함 -->

</body>
</html>
