<?php
session_start();

// 카카오페이 결제 준비 요청
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://kapi.kakao.com/v1/payment/ready",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query([
        'cid' => 'TC0ONETIME', // 테스트용 CID
        'partner_order_id' => 'order_id_1001',
        'partner_user_id' => 'user_abc123',
        'item_name' => 'ReadUS 책 결제',
        'quantity' => 1,
        'total_amount' => 10000,
        'vat_amount' => 0,
        'tax_free_amount' => 0,
        'approval_url' => 'http://localhost/kakaopay_approve.php',
        'cancel_url' => 'http://localhost/kakaopay_cancel.php',
        'fail_url' => 'http://localhost/kakaopay_fail.php'
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: KakaoAK d2ac0161dcc07ff1b1a19822ed113b9d",
        "Content-type: application/x-www-form-urlencoded;charset=utf-8"
    ]
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo "카카오페이 요청 실패: " . $err;
    exit;
}

$result = json_decode($response, true);

// tid를 세션에 저장 (결제 승인 때 필요)
$_SESSION['tid'] = $result['tid'];
$_SESSION['partner_order_id'] = 'order_id_1001';
$_SESSION['partner_user_id'] = 'user_abc123';

// QR 코드 생성 (Google Chart API 이용)
$qr_url = $result['next_redirect_pc_url'];  // 결제 URL

// Google Chart API를 이용한 QR 코드 이미지 주소
$qr_code_url = "https://chart.googleapis.com/chart?cht=qr&chs=300x300&chl=" . urlencode($qr_url);

?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>카카오페이 QR코드 결제</title>
</head>
<body>
    <h2>아래 QR 코드를 카카오페이로 결제하세요!</h2>
    <img src="<?php echo $qr_code_url; ?>" alt="카카오페이 QR 코드">
</body>
</html>
