<?php
session_start();

// 테스트용 키(발급 받은 카카오페이 앱 키로 변경하세요)
define('KAKAO_ADMIN_KEY', 'YOUR_ADMIN_KEY_HERE');

// 임시로 장바구니, 총 결제금액 설정 (실제로는 세션이나 DB에서 불러옴)
$cart = $_SESSION['cart'] ?? [];
if (empty($cart)) {
    echo "장바구니가 비어있습니다.";
    exit;
}

// 총 금액 계산 (여기선 임의로 1000원)
$totalAmount = 1000;

// 결제 준비 요청 URL
$apiUrl = "https://kapi.kakao.com/v1/payment/ready";

// 요청 헤더
$headers = [
    "Authorization: KakaoAK " . KAKAO_ADMIN_KEY,
    "Content-type: application/x-www-form-urlencoded;charset=utf-8",
];

// 요청 데이터 (필요에 맞게 변경)
$postData = http_build_query([
    'cid' => 'TC0ONETIME', // 테스트용 가맹점 코드
    'partner_order_id' => uniqid(),  // 주문번호
    'partner_user_id' => 'user123',  // 사용자 ID
    'item_name' => 'ReadUS 도서 구매',  // 상품명
    'quantity' => 1,
    'total_amount' => $totalAmount,
    'vat_amount' => (int)($totalAmount / 10),
    'tax_free_amount' => 0,
    'approval_url' => 'http://yourdomain.com/kakaopay_approve.php',
    'cancel_url' => 'http://yourdomain.com/kakaopay_cancel.php',
    'fail_url' => 'http://yourdomain.com/kakaopay_fail.php',
]);

// curl로 요청 보내기
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

if (isset($data['next_redirect_pc_url'])) {
    // 결제 페이지 URL 세션에 저장 (결제 승인 시 필요)
    $_SESSION['tid'] = $data['tid']; 
    $_SESSION['partner_order_id'] = $postData['partner_order_id'];
    $_SESSION['partner_user_id'] = $postData['partner_user_id'];

    // 결제 페이지로 리다이렉트
    header('Location: ' . $data['next_redirect_pc_url']);
    exit;
} else {
    echo "결제 준비 실패: " . $response;
}
?>
