<?php
session_start();

if (!isset($_GET['pg_token'])) {
    echo "결제 승인 실패: pg_token이 없습니다.";
    exit;
}

$pg_token = $_GET['pg_token'];

// 테스트용 키
define('KAKAO_ADMIN_KEY', 'YOUR_ADMIN_KEY_HERE');

$apiUrl = "https://kapi.kakao.com/v1/payment/approve";

$headers = [
    "Authorization: KakaoAK " . KAKAO_ADMIN_KEY,
    "Content-type: application/x-www-form-urlencoded;charset=utf-8",
];

$postData = http_build_query([
    'cid' => 'TC0ONETIME',
    'tid' => $_SESSION['tid'],  // 결제 준비 때 저장한 tid
    'partner_order_id' => $_SESSION['partner_order_id'],
    'partner_user_id' => $_SESSION['partner_user_id'],
    'pg_token' => $pg_token,
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

if (isset($data['aid'])) {
    // 결제 성공 시 처리 (DB 저장, 영수증 출력 등)
    echo "<h2>결제 완료</h2>";
    echo "<p>주문번호: " . htmlspecialchars($data['partner_order_id']) . "</p>";
    echo "<p>결제금액: " . number_format($data['amount']['total']) . " 원</p>";
    echo "<p>결제 시간: " . htmlspecialchars($data['approved_at']) . "</p>";
    // 필요하면 세션 정리 등 추가 처리
    session_destroy();
} else {
    echo "결제 승인 실패: " . $response;
}
?>
