<?php
session_start();

// 명언 랜덤
$quotes = [
    "독서는 당신의 삶을 변화시킬 수 있습니다.",
    "하루 10분 독서가 인생을 바꿉니다.",
    "좋은 책은 좋은 친구입니다.",
    "책은 마음의 양식입니다.",
    "오늘의 한 권이 내일의 나를 만납니다.",
    "책과 함께하는 시간은 헛되지 않습니다.",
    "하루 한 문장, 생각의 깊이가 달라집니다.",
    "독서는 생각을 위한 가장 강력한 도구입니다."
];
$randomQuote = $quotes[array_rand($quotes)]; // 배열에서 무작위 명언 선택

// DB 연결
include('db.php');

// 카테고리와 이달의 책 데이터 가져오기
$categories = [];
$monthlyBooks = [];

// categories 테이블에서 모든 카테고리명 가져오기
$sql = "SELECT * FROM categories";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row['name']; // 각 카테고리명을 배열에 저장
    }
}

// 이달의 책(플래그가 켜진 책 최대 6권) 가져오기
$sql = "
    SELECT *
    FROM books
    WHERE is_monthly_featured = 1
    ORDER BY id DESC
    LIMIT 6
";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $monthlyBooks[] = $row; // 이달의 책 데이터를 배열에 저장
    }
}
?>

<!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>ReadUS 홈</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/styles.css" />
</head>

<body>
    <!-- 헤더 -->
    <div class="header page-section">
        <div class="logo">
            <a href="index.php">ReadUS</a> <!-- 로고 클릭 시 홈으로 이동 -->
        </div>

        <style> 
        /* 여기서부터 CSS 스타일 코드 시작 */

        /* body 기본 스타일 설정: 가운데 정렬, 폰트, 배경색, 최대 너비 지정 */
        body {
            margin: 0 auto;
            font-family: Arial, sans-serif;
            background-color: #f3f4f6;
            width: 1280px;
        }
        /* CSS 변수 선언: 기본 색상과 그라데이션 */
        :root {
            --primary: #6a5acd;
            --accent: #f9f9ff;
            --text: #333;
            --gradient: linear-gradient(135deg, #bcbdf5, #e4dcff);
        }

        /* 전체 배경 스타일 */
        .main-wrapper {
            background: linear-gradient(to bottom, #f8f8ff, #ffffff);
            min-height: 100vh;
            padding: 30px 15px;
            box-sizing: border-box;
        }

        /* 공통 폰트 적용: 제목, 문단, 링크, 스팬 */
        h1, h2, h3, p, a, span {
            font-family: 'Noto Sans KR', sans-serif;
        }

        /* 섹션 제목 스타일 */
        .category-title,
        .section-title,
        .share-title {
            font-weight: 700;
            font-size: 1.3rem;
            margin-bottom: 8px;
            text-align: center;
            color: var(--primary);
        }

        /* 제목 밑줄 스타일 */
        .underline {
            width: 80px;
            height: 3px;
            background: var(--gradient);
            margin: 0 auto 15px auto;
            border-radius: 2px;
        }

        /* 카테고리 리스트 스타일: 플렉스 박스 사용, 줄바꿈, 가운데 정렬, 간격 조절 */
        .category-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 12px; /* 아이템 간 간격 */
            padding: 10px 0;
        }

        /* 개별 카테고리 아이템 스타일: 배경색, 둥근 모서리, 그림자, 글자 스타일, 마우스 효과 */
        .category-item {
            background: #f9f9fc; /* 아주 연한 회색 */
            border-radius: 20px;
            border: 1px solid #d8d9e6; /* 연한 라이트 그레이 테두리 */
            box-shadow:
              4px 4px 6px #e0e1eb,  /* 부드러운 그림자 */
              -4px -4px 6px #ffffff;
            color: #2c3e50;
            padding: 8px 18px;
            font-weight: 600;
            font-size: 0.9rem;
            transition: background-color 0.3s ease, box-shadow 0.3s ease, color 0.3s ease, border-color 0.3s ease;
            cursor: pointer;
            user-select: none; /* 텍스트 선택 방지 */
        }

        /* 카테고리 아이템 호버 시 효과: 배경색, 테두리, 그림자, 글자색 변경 */
        .category-item:hover {
            background-color: #e6e6fa; /* 연한 라벤더 */
            border-color: #5a4bcf; /* 진한 보라 테두리 */
            box-shadow:
              inset 3px 3px 8px #c7c9db,
              inset -3px -3px 8px #ffffff;
            color: #5a4bcf;
        }

        /* 이달의 책 제목 부분 스타일 */
        .monthly-books-header {
            text-align: center;
            margin-bottom: 15px;
        }

        /* 책 추가 버튼 스타일 */
        .add-book-button {
            margin-left: 4px;
            font-size: 1.3rem;
            vertical-align: middle;
            cursor: pointer;
            color: var(--primary);
            text-decoration: none;
            font-weight: 700;
        }

        /* 이달의 책 리스트 그리드 스타일: 최소 최대 크기 설정 및 간격 */
        .monthly-books {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
            gap: 10px;
            justify-items: center;
        }

        /* 책 카드 스타일: 크기, 정렬, 테두리, 그림자 */
        .book-card {
            width: 160px;
            text-align: center;
            padding: 10px;
            border: 1.5px solid #e0ddf7;
            border-radius: 12px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            background-color: #ffffff;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
        }

        /* 책 카드 호버 시 살짝 확대 및 그림자 증가 */
        .book-card:hover {
            transform: translateY(-6px) scale(1.03);
            box-shadow: 0 8px 16px rgba(106, 90, 205, 0.2);
        }

        /* 책 표지 이미지 스타일: 너비 100%, 둥근 모서리 */
        .book-card img {
            width: 100%;
            height: auto;
            border-radius: 6px;
        }

        /* 책 제목 텍스트 스타일 */
        .book-title {
            margin-top: 6px;
            font-weight: 600;
            font-size: 0.95rem;
            color: var(--text);
        }

        /* Read & Share 박스 스타일: 배경, 테두리, 둥근 모서리, 폰트, 그림자, 중앙 정렬 */
        .share-box {
            background: #f9f9fc;
            border: 1px solid #d8d9e6;
            border-radius: 20px;
            padding: 10px 20px;
            font-size: 0.9rem;
            font-weight: 600;
            color: #2c3e50;
            min-width: 130px;
            height: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            transition: all 0.3s ease;
            box-shadow:
                4px 4px 6px #e0e1eb,
                -4px -4px 6px #ffffff;
            cursor: pointer;
            user-select: none;
        }

        /* Read & Share 박스 내 링크 스타일: 글자색 유지, 링크 기본 스타일 제거, 전체 크기 차지 */
        .share-box a {
            color: inherit;
            text-decoration: none;
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Read & Share 박스 호버 시 배경색, 테두리, 그림자, 글자색 변경 */
        .share-box:hover {
            background-color: #e6e6fa;
            border-color: #5a4bcf;
            box-shadow:
                inset 3px 3px 8px #c7c9db,
                inset -3px -3px 8px #ffffff;
            color: #5a4bcf;
        }

        /* Read & Share 컨테이너 플렉스 스타일, 줄바꿈, 가운데 정렬, 간격, 위쪽 마진 */
        .share-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 30px; /* 박스 사이 간격 */
            margin-top: 10px; /* 위쪽 여백 */
        }
        </style>

        <!-- 검색바 -->
        <div class="search-bar">
          <form id="search-form" action="search.php" method="GET" novalidate>
            <input type="text" id="search-input" name="query" placeholder="책 제목을 입력하세요" autocomplete="off" />
            <button class="search-btn" type="submit">
              <!-- 돋보기 아이콘 SVG -->
              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                   viewBox="0 0 16 16">
                <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001l3.85 
                3.85a1 1 0 0 0 1.415-1.415l-3.85-3.85zm-5.242 
                1.406a5 5 0 1 1 0-10 5 5 0 0 1 0 10z"/>
              </svg>
              검색
            </button>
          </form>
          <div id="search-warning" class="search-warning">검색어를 입력해주세요.</div>
        </div>

        <script>
          // 검색 폼 제출 시 빈 값 검사 후 경고 메시지 출력 및 제출 방지
          const form = document.getElementById('search-form');
          const input = document.getElementById('search-input');
          const warning = document.getElementById('search-warning');

          form.addEventListener('submit', function(e) {
            if(input.value.trim() === '') {
              e.preventDefault(); // 빈 값이면 제출 막음
              warning.classList.add('show'); // 경고 표시
              input.focus();

              setTimeout(() => {
                warning.classList.remove('show'); // 3초 후 경고 숨김
              }, 3000);
            }
          });
        </script>

        <div class="menu">
            <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                <!-- 로그인 상태일 때 환영 메시지 및 여러 메뉴 링크 출력 -->
                <span class="welcome-message"><?php echo htmlspecialchars($_SESSION['username']); ?>님</span>
                <a href="edit-profile.php" title="회원정보 수정">⚙️</a>
                <a href="logout.php" title="로그아웃">🚪</a>
                <a href="mypage.php" title="MyPage">📚</a>
                <a href="wishlist.php" title="보관함">💖</a>
                <a href="cart.php" title="장바구니">🛒</a>
            <?php else: ?>
                <!-- 로그아웃 상태일 때 로그인/회원가입 링크 출력 -->
                <a href="login.php" title="로그인">🔐</a>
                <a href="signup.php" title="회원가입">👤</a>
            <?php endif; ?>
        </div>
    </div>

    <!-- 명언 섹션 -->
    <div class="quote-container page-section">
        <h3 class="quote-title">📖 책과 함께하는 오늘</h3>
        <p id="quote-text"><?php echo $randomQuote; ?></p> <!-- 무작위 명언 출력 -->
    </div>

    <!-- 카테고리 섹션 -->
    <h2 class="category-title page-section">카테고리</h2>
    <div class="underline"></div>
    <div class="category-container page-section">
        <?php foreach ($categories as $category): ?>
        <!-- 카테고리명 링크 출력, 클릭 시 카테고리별 페이지로 이동 -->
        <a href="category.php?name=<?php echo urlencode($category); ?>" class="category-item"><?php echo htmlspecialchars($category); ?></a>
        <?php endforeach; ?>
    </div>

    <!-- 이달의 책 섹션 -->
    <div class="monthly-books-header page-section">
        <h2 class="section-title">
            이달의 책
            <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                <!-- 로그인 상태일 때만 책 추가 버튼 표시 -->
                <a href="add-book.php" class="add-book-button">➕</a>
            <?php endif; ?>
        </h2>
    </div>
    <div class="underline"></div>
    <div class="monthly-books page-section">
        <?php if (empty($monthlyBooks)): ?>
            <!-- 등록된 이달의 책이 없을 경우 안내 문구 -->
            <p class="no-books">이달의 책이 아직 등록되지 않았습니다.</p>
        <?php else: ?>
            <?php foreach ($monthlyBooks as $book): ?>
                <div class="book-card">
                    <?php
                    // 책 표지 이미지 경로 설정, 없으면 기본 이미지 사용
                    $imgPath = !empty($book['cover_image'])
                        ? htmlspecialchars($book['cover_image']) // 이미지 경로 안전하게 출력
                        : 'img/default-book-cover.jpg';
                    ?>
                    <img src="<?php echo $imgPath; ?>" alt="책 표지" />
                    <div class="book-title"><?php echo htmlspecialchars($book['title']); ?></div> <!-- 책 제목 출력 -->
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <!-- Read & Share 섹션 -->
    <h2 class="share-title page-section">Read & Share</h2>
    <div class="underline"></div>
    <div class="share-container page-section">
        <!-- 친구 추가, 책 추천하기, 추천 내역 관리 링크 -->
        <div class="share-box"><a href="friends.php">친구 추가</a></div>
        <div class="share-box"><a href="recommend-book.php">책 추천하기</a></div>
        <div class="share-box"><a href="recommend-history.php">추천 내역 관리</a></div>
    </div>

    </div>

    <!-- 푸터 -->
    <div class="footer-box page-section">
        <div class="footer-item">안산대학교</div>
        <div class="footer-item">010-0000-0000</div>
        <div class="footer-item">shinyourim@ansan.ac.kr</div>
    </div>
</body>

</html>
