<?php
session_start();  // 세션 시작 (필요 시 세션 데이터를 사용하기 위함)
include('db.php'); // DB 연결 파일 포함

$categoryName = '경제/투자';  // 조회할 카테고리 이름 설정
$categoryId = null;           // 카테고리 ID 저장용 변수 초기화
$books = [];                  // 책 목록 저장용 빈 배열 초기화

// 카테고리 이름으로 카테고리 ID를 가져오는 쿼리 준비 및 실행
$stmt = $conn->prepare("SELECT id FROM categories WHERE name = ?");
$stmt->bind_param("s", $categoryName);  // ?에 $categoryName 바인딩
$stmt->execute();                       // 쿼리 실행
$stmt->bind_result($categoryId);        // 결과를 $categoryId에 바인딩
$stmt->fetch();                         // 결과 가져오기
$stmt->close();                        // 준비한 쿼리 종료

// 카테고리가 없으면 오류 메시지 출력 후 종료
if (!$categoryId) {
    echo "❌ '경제/투자' 카테고리가 존재하지 않습니다.";
    exit;
}

// 카테고리 ID로 해당 카테고리에 속한 책 목록 가져오기 위한 쿼리 준비 및 실행
$stmt = $conn->prepare("SELECT * FROM books WHERE category_id = ?");
$stmt->bind_param("i", $categoryId);   // ?에 카테고리 ID 바인딩
$stmt->execute();                      // 쿼리 실행
$result = $stmt->get_result();         // 결과 가져오기

// 결과를 배열에 저장
while ($row = $result->fetch_assoc()) {
    $books[] = $row;
}
$stmt->close();  // 쿼리 종료
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>경제/투자 도서 목록</title>
    <link rel="stylesheet" href="css/styles.css"> <!-- CSS 파일 연결 -->
</head>
<style>
    body {
        margin: 0 auto;
        font-family: Arial, sans-serif;
        background-color: #f3f4f6;
        width: 1280px;
    }
</style>
<body>
    <h2>📚 경제/투자 카테고리 도서 목록</h2>

    <?php if (empty($books)): ?>
        <p>등록된 책이 없습니다.</p> <!-- 책 목록이 비어 있을 때 출력 -->
    <?php else: ?>
        <div class="monthly-books page-section">
            <?php foreach ($books as $book): ?>
                <div class="book-card">
                    <!-- 책 표지 이미지 출력, 없으면 기본 이미지 사용 -->
                    <img src="<?php echo htmlspecialchars($book['cover_image'] ?? 'default-book-cover.jpg'); ?>" alt="책 표지">
                    <!-- 책 제목 출력 -->
                    <div class="book-title"><?php echo htmlspecialchars($book['title']); ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <br>
    <a href="index.php">← 메인으로</a> <!-- 메인 페이지로 이동하는 링크 -->
</body>
</html>
