<?php
include('db.php'); // DB 연결
error_reporting(E_ALL);
ini_set('display_errors', 1);

$message = ""; // 사용자에게 보여줄 메시지 변수 초기화

if (isset($_POST['submit'])) {  // 폼이 제출되었을 때
    $book_title = trim($_POST['book_title']);  // 입력된 책 제목 가져오기 및 공백 제거

    // 이미지 파일이 정상적으로 업로드되었는지 확인
    if (!isset($_FILES['book_image']) || $_FILES['book_image']['error'] !== UPLOAD_ERR_OK) {
        $message = "<p class='error'>❌ 이미지 파일을 선택하고 다시 시도해주세요.</p>";
    } else {
        // 이미지 저장할 폴더 경로 설정
        $upload_dir = __DIR__ . '/img/';
        // 폴더가 없으면 생성 시도
        if (!is_dir($upload_dir) && !mkdir($upload_dir, 0755, true)) {
            $message = "<p class='error'>❌ 이미지 저장 폴더를 만들 수 없습니다. 서버 권한을 확인하세요.</p>";
        }

        // 허용할 이미지 확장자 목록
        $allowed = ['jpg','jpeg','png','gif'];
        // 업로드된 파일의 확장자 추출 및 소문자 변환
        $ext = strtolower(pathinfo($_FILES['book_image']['name'], PATHINFO_EXTENSION));
        // 확장자가 허용 목록에 없으면 오류 메시지 설정
        if (!in_array($ext, $allowed)) {
            $message = "<p class='error'>❌ JPG, JPEG, PNG, GIF 파일만 업로드 가능합니다.</p>";
        }

        // 오류가 없으면 이미지 업로드 및 DB 저장 진행
        if (empty($message)) {
            $orig = basename($_FILES['book_image']['name']);  // 원본 파일명
            $uniq  = uniqid() . '_' . $orig;                  // 고유한 파일명 생성
            $target = $upload_dir . $uniq;                     // 서버에 저장할 경로

            // 임시 저장된 파일을 지정 경로로 이동
            if (move_uploaded_file($_FILES['book_image']['tmp_name'], $target)) {
                $file_path_db = 'img/' . $uniq;  // DB에 저장할 경로 (상대경로)
                $is_monthly_featured = 1;        // 이달의 책 표시 플래그

                // 도서 정보 DB에 삽입하는 쿼리 준비
                $sql = "INSERT INTO books 
                        (title, cover_image, is_monthly_featured) 
                        VALUES (?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssi", $book_title, $file_path_db, $is_monthly_featured);

                // 쿼리 실행 및 성공 여부에 따른 메시지 설정
                if ($stmt->execute()) {
                    $message = "<p class='success'>✅ 이달의 책이 성공적으로 등록되었습니다!</p>";
                } else {
                    $message = "<p class='error'>❌ DB 오류: " . htmlspecialchars($conn->error) . "</p>";
                }

                $stmt->close();
            } else {
                $message = "<p class='error'>❌ 이미지 업로드에 실패했습니다. 경로·권한을 확인하세요.</p>";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>이달의 책 추가</title>
    <link rel="stylesheet" href="css/styles.css">
</head>
<style>
    body {
        margin: 0 auto;
        font-family: Arial, sans-serif;
        background-color: #f3f4f6;
        width: 1280px;
    }
</style>
<body>
    <!-- 헤더 영역 -->
    <div class="header page-section">
        <div class="logo">
            <a href="index.php">ReadUS</a>
        </div>
        <div class="menu">
            <?php if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true): ?>
                <!-- 로그인 상태일 때 환영 메시지 및 메뉴 링크 -->
                <span class="welcome-message"><?php echo htmlspecialchars($_SESSION['username']); ?>님</span>
                <a href="edit-profile.php" title="회원정보 수정">⚙️</a>
                <a href="logout.php" title="로그아웃">🚪</a>
                <a href="mypage.php" title="MyPage">📚</a>
                <a href="wishlist.php" title="보관함">💖</a>
                <a href="cart.php" title="장바구니">🛒</a>
            <?php else: ?>
                <!-- 비로그인 상태일 때 로그인 및 회원가입 링크 -->
                <a href="login.php" title="로그인">🔐</a>
                <a href="signup.php" title="회원가입">👤</a>
            <?php endif; ?>
        </div>
    </div>

    <div class="add-book-page">
        <h2>📚 이달의 책 등록</h2>
        <!-- 메시지 출력 (성공 또는 에러) -->
        <?php if ($message): echo $message; endif; ?>

        <!-- 책 등록 폼 -->
        <form action="add-book.php" method="POST" enctype="multipart/form-data">
            <label for="book-title">책 제목:</label>
            <input type="text" id="book-title" name="book_title" required>

            <label for="book-image">책 이미지:</label>
            <input type="file" id="book-image" name="book_image" accept="image/*" required>

            <button type="submit" name="submit">등록하기</button>
        </form>
    </div>
</body>
</html>
