<?php
header("Content-Type: application/json; charset=UTF-8");

$host = "infodb.ansan.ac.kr";
$user = "i2151063";
$pass = "ekfsla11"; // DB 비밀번호
$db = "db2151063_damanpi"; // DB 이름

$conn = new mysqli($host, $user, $pass, $db);

// DB 연결 오류 처리
if ($conn->connect_error) {
    echo json_encode(array("result" => "error", "message" => "DB 연결 실패: " . $conn->connect_error));
    exit();
}

// POST로 받은 데이터 받기
$id = $_POST['아이디'];
$password = $_POST['비밀번호'];
$name = $_POST['이름'];
$nickname = $_POST['닉네임'];
$email = $_POST['이메일'];

// 비밀번호 암호화 (보안상 이유)
$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

// 이미 아이디가 존재하는지 체크
$stmt = $conn->prepare("SELECT * FROM 회원 WHERE 아이디 = ?");
$stmt->bind_param("s", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode(array("result" => "fail", "message" => "이미 존재하는 아이디입니다."));
} else {
    // 회원가입 정보 DB에 INSERT
    $stmt = $conn->prepare("INSERT INTO 회원 (아이디, 비밀번호, 이름, 닉네임, 이메일) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $id, $hashedPassword, $name, $nickname, $email);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo json_encode(array("result" => "success", "message" => "회원가입이 완료되었습니다."));
    } else {
        echo json_encode(array("result" => "fail", "message" => "회원가입에 실패하였습니다."));
    }
}

$stmt->close();
$conn->close();
?>
