package com.example.smoking;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class reviewActivity extends AppCompatActivity {

    private LinearLayout listContainer;
    private final String PHP_URL = "https://infognu.ansan.ac.kr/~i2151046/smoking/get_smoking_areas.php";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_review);

        listContainer = findViewById(R.id.listContainer);

        loadSmokingAreas();
    }

    private void loadSmokingAreas() {
        new Thread(() -> {
            try {
                URL url = new URL(PHP_URL);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("GET");

                BufferedReader reader = new BufferedReader(
                        new InputStreamReader(conn.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                String line;

                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }

                reader.close();

                JSONArray jsonArray = new JSONArray(response.toString());

                runOnUiThread(() -> {
                    try {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject obj = jsonArray.getJSONObject(i);

                            int id = obj.getInt("id"); // ✅ 추가됨
                            String name = obj.getString("name");
                            String imageUrl = obj.getString("image_url");

                            float rating = 0.0f;
                            if (obj.has("rating") && !obj.isNull("rating")) {
                                rating = (float) obj.getDouble("rating");
                            }

                            addListItem(id, name, imageUrl, rating); // ✅ id 포함
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });

            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    // ✅ id 인자 추가
    private void addListItem(int id, String name, String imageUrl, float rating) {
        View item = LayoutInflater.from(this).inflate(R.layout.item_smoking_area, null);

        TextView nameText = item.findViewById(R.id.nameText);
        RatingBar ratingBar = item.findViewById(R.id.ratingBar);
        ImageView imageThumb = item.findViewById(R.id.imageThumb);

        nameText.setText(name);
        ratingBar.setRating(rating);

        if (imageUrl != null && !imageUrl.isEmpty()) {
            Glide.with(this)
                    .load(imageUrl)
                    .placeholder(R.drawable.logo)
                    .into(imageThumb);
        } else {
            imageThumb.setImageResource(R.drawable.logo);
        }

        // ✅ 클릭 시 상세 페이지로 이동
        item.setOnClickListener(v -> {
            Intent intent = new Intent(this, DetailActivity.class);
            intent.putExtra("id", id);
            intent.putExtra("name", name);
            intent.putExtra("image_url", imageUrl);
            startActivity(intent);
        });

        listContainer.addView(item);
    }
}
