package com.example.smoking;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class registerActivity extends AppCompatActivity {

    EditText editTextId, editTextPassword, editTextConfirmPassword, editTextName, editTextNickname, editTextEmail;
    Button btnRegister;
    String url = "https://infognu.ansan.ac.kr/~i2151046/smoking/register.php"; // PHP 서버 URL

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.register);

        // UI 요소 초기화
        editTextId = findViewById(R.id.editTextId);
        editTextPassword = findViewById(R.id.editTextPassword);
        editTextConfirmPassword = findViewById(R.id.editTextConfirmPassword);
        editTextName = findViewById(R.id.editTextName);
        editTextNickname = findViewById(R.id.editTextNickname);
        editTextEmail = findViewById(R.id.editTextEmail);
        btnRegister = findViewById(R.id.btnRegister);

        // 가입하기 버튼 클릭 시 처리
        btnRegister.setOnClickListener(v -> {
            String id = editTextId.getText().toString();
            String password = editTextPassword.getText().toString();
            String confirmPassword = editTextConfirmPassword.getText().toString();
            String name = editTextName.getText().toString();
            String nickname = editTextNickname.getText().toString();
            String email = editTextEmail.getText().toString();

            // 입력값 체크
            if (!id.isEmpty() && !password.isEmpty() && !confirmPassword.isEmpty() && !name.isEmpty() && !nickname.isEmpty() && !email.isEmpty()) {
                if (password.equals(confirmPassword)) {
                    // 회원가입 요청
                    registerUser(id, password, name, nickname, email);
                } else {
                    Toast.makeText(registerActivity.this, "비밀번호가 일치하지 않습니다.", Toast.LENGTH_SHORT).show();
                }
            } else {
                Toast.makeText(registerActivity.this, "모든 필드를 입력해주세요.", Toast.LENGTH_SHORT).show();
            }
        });
    }

    // 서버로 회원가입 요청 보내는 메소드
    private void registerUser(String id, String password, String name, String nickname, String email) {
        StringRequest stringRequest = new StringRequest(Request.Method.POST, url,
                response -> {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        String status = jsonObject.getString("result");
                        String message = jsonObject.getString("message");

                        Toast.makeText(registerActivity.this, message, Toast.LENGTH_SHORT).show();
                        if (status.equals("success")) {
                            finish(); // 회원가입 후 로그인 화면으로 돌아가기
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                        Toast.makeText(registerActivity.this, "응답 파싱 실패", Toast.LENGTH_SHORT).show();
                    }
                },
                error -> Toast.makeText(registerActivity.this, "서버 오류 발생", Toast.LENGTH_SHORT).show()) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("아이디", id);
                params.put("비밀번호", password);
                params.put("이름", name);
                params.put("닉네임", nickname);
                params.put("이메일", email);
                return params;
            }
        };

        // Volley를 이용한 네트워크 요청
        RequestQueue queue = Volley.newRequestQueue(this);
        queue.add(stringRequest);
    }
}
