package com.example.smoking;

import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;

import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;

import java.util.Map;

public class SmokingCountDecorator implements DayViewDecorator {

    private final Map<CalendarDay, Integer> habitMap;
    private CalendarDay currentDay; // 현재 데코레이팅 중인 날짜 저장

    public SmokingCountDecorator(Map<CalendarDay, Integer> habitMap) {
        this.habitMap = habitMap;
    }

    @Override
    public boolean shouldDecorate(CalendarDay day) {
        if (habitMap.containsKey(day)) {
            currentDay = day; // 현재 날짜 기억
            return true;
        }
        return false;
    }

    @Override
    public void decorate(DayViewFacade view) {
        if (currentDay == null) return;

        int count = habitMap.getOrDefault(currentDay, 0);
        SpannableString span = new SpannableString(String.valueOf(count));
        span.setSpan(new ForegroundColorSpan(Color.RED), 0, span.length(), 0);
        span.setSpan(new RelativeSizeSpan(0.7f), 0, span.length(), 0);
        view.addSpan(span);

        currentDay = null; // 사용 후 초기화
    }
}
