package com.example.smoking;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

public class SettingsFragment extends DialogFragment {

    public SettingsFragment() {}

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog() != null && getDialog().getWindow() != null) {
            Window window = getDialog().getWindow();
            window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            window.setBackgroundDrawable(new ColorDrawable(Color.parseColor("#AAFFFFFF"))); // 반투명 흰 배경
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater,
                             @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_settings, container, false);

        // 닫기 버튼
        Button closeBtn = view.findViewById(R.id.btn_close);
        closeBtn.setOnClickListener(v -> dismiss());

        // 사용자 정보 버튼
        ImageButton btnUser = view.findViewById(R.id.btnUser);
        btnUser.setOnClickListener(v -> {
            Intent intent = new Intent(requireActivity(), MyInfoActivity.class);
            startActivity(intent);
        });

        // 공지/이벤트 버튼
        ImageButton btnFNotification = view.findViewById(R.id.btnFNotification);
        btnFNotification.setOnClickListener(v -> {
            Intent intent = new Intent(requireActivity(), NoticeEventActivity.class);
            startActivity(intent);
        });

        // 관리자 번호 토글
        ImageButton btnAdminNumber = view.findViewById(R.id.btnAdminNumber);
        LinearLayout adminNumberContainer = view.findViewById(R.id.adminNumberContainer);

        btnAdminNumber.setOnClickListener(v -> {
            if (adminNumberContainer.getVisibility() == View.GONE) {
                adminNumberContainer.setVisibility(View.VISIBLE);
                adminNumberContainer.animate()
                        .translationX(0f)
                        .alpha(1f)
                        .setDuration(300)
                        .start();
            } else {
                adminNumberContainer.animate()
                        .translationX(adminNumberContainer.getWidth())
                        .alpha(0f)
                        .setDuration(300)
                        .withEndAction(() -> adminNumberContainer.setVisibility(View.GONE))
                        .start();
            }
        });

        return view;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        return dialog;
    }
}
