package com.example.smoking;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RatingBar;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.util.HashMap;
import java.util.Map;

public class ReviewWriteActivity extends AppCompatActivity {

    private EditText editContent;
    private RatingBar ratingBar;
    private Button btnSubmit;

    private int smokingAreaId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_review_write);

        editContent = findViewById(R.id.editContent);
        ratingBar = findViewById(R.id.ratingBar);
        btnSubmit = findViewById(R.id.btnSubmit);

        // DetailActivity에서 흡연구역 ID 받기
        smokingAreaId = getIntent().getIntExtra("id", -1);
        Log.d("ReviewWriteActivity", "smokingAreaId: " + smokingAreaId); // ✅ 로그 확인

        btnSubmit.setOnClickListener(v -> submitReview());
    }

    private void submitReview() {
        String content = editContent.getText().toString().trim();
        float rating = ratingBar.getRating();

        // SharedPreferences에서 로그인한 사용자 ID 읽기
        SharedPreferences prefs = getSharedPreferences("MyAppPrefs", MODE_PRIVATE);
        int userId = prefs.getInt("userId", -1);
        Log.d("ReviewWriteActivity", "userId: " + userId); // ✅ 로그 확인

        if (content.isEmpty() || rating == 0.0f) {
            Toast.makeText(this, "내용과 별점을 모두 입력해주세요.", Toast.LENGTH_SHORT).show();
            return;
        }

        if (userId == -1) {
            Toast.makeText(this, "사용자 정보가 없습니다. 로그인해주세요.", Toast.LENGTH_SHORT).show();
            return;
        }

        String url = "https://infognu.ansan.ac.kr/~i2151046/smoking/save_review.php";

        RequestQueue queue = Volley.newRequestQueue(this);

        StringRequest request = new StringRequest(Request.Method.POST, url,
                response -> {
                    Toast.makeText(this, "리뷰가 등록되었습니다.", Toast.LENGTH_SHORT).show();
                    setResult(RESULT_OK);
                    finish();
                },
                error -> {
                    Toast.makeText(this, "리뷰 등록 실패: " + error.getMessage(), Toast.LENGTH_LONG).show();
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("구역ID", String.valueOf(smokingAreaId));
                params.put("회원ID", String.valueOf(userId));
                params.put("별점", String.valueOf(rating));
                params.put("리뷰내용", content);
                return params;
            }
        };

        queue.add(request);
    }
}
