package com.example.smoking;

import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class NoticeEventActivity extends AppCompatActivity {

    private ViewFlipper viewFlipper;
    private LinearLayout layoutNotice, layoutEvent;
    private TextView tabNotice, tabEvent;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_notice_event);

        viewFlipper = findViewById(R.id.view_flipper);
        layoutNotice = findViewById(R.id.layout_notice_content);
        layoutEvent = findViewById(R.id.layout_event_content);

        tabNotice = findViewById(R.id.tab_notice);
        tabEvent = findViewById(R.id.tab_event);

        tabNotice.setOnClickListener(v -> {
            viewFlipper.setDisplayedChild(0);
            tabNotice.setTextColor(ContextCompat.getColor(this, R.color.purple_700));
            tabEvent.setTextColor(ContextCompat.getColor(this, R.color.black));
        });

        tabEvent.setOnClickListener(v -> {
            viewFlipper.setDisplayedChild(1);
            tabEvent.setTextColor(ContextCompat.getColor(this, R.color.purple_700));
            tabNotice.setTextColor(ContextCompat.getColor(this, R.color.black));
        });

        loadNoticeData("https://infognu.ansan.ac.kr/~i2151046/smoking/notice.php");
        loadEventData("https://infognu.ansan.ac.kr/~i2151046/smoking/events.php");
    }

    private void loadNoticeData(String urlString) {
        new Thread(() -> {
            try {
                HttpURLConnection conn = (HttpURLConnection) new URL(urlString).openConnection();
                conn.setRequestMethod("GET");

                BufferedReader reader = new BufferedReader(
                        new InputStreamReader(conn.getInputStream()));
                StringBuilder result = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }

                JSONArray jsonArray = new JSONObject(result.toString()).getJSONArray("notices");

                runOnUiThread(() -> {
                    layoutNotice.removeAllViews();

                    for (int i = 0; i < jsonArray.length(); i++) {
                        try {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            String title = obj.getString("제목");
                            String content = obj.getString("내용");
                            String date = obj.getString("작성일");
                            JSONArray photos = obj.optJSONArray("사진들");

                            LinearLayout card = createCard(title, content, date, photos);
                            layoutNotice.addView(card);

                            addSpacing(layoutNotice);

                        } catch (Exception e) {
                            Log.e("NoticeError", "공지사항 파싱 오류: " + e.getMessage());
                        }
                    }
                });

            } catch (Exception e) {
                e.printStackTrace();
                Log.e("NoticeError", "공지사항 불러오기 실패: " + e.getMessage());
            }
        }).start();
    }

    private void loadEventData(String urlString) {
        new Thread(() -> {
            try {
                HttpURLConnection conn = (HttpURLConnection) new URL(urlString).openConnection();
                conn.setRequestMethod("GET");

                BufferedReader reader = new BufferedReader(
                        new InputStreamReader(conn.getInputStream()));
                StringBuilder result = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }

                JSONArray jsonArray = new JSONObject(result.toString()).getJSONArray("events");

                runOnUiThread(() -> {
                    layoutEvent.removeAllViews();

                    for (int i = 0; i < jsonArray.length(); i++) {
                        try {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            String title = obj.getString("제목");
                            String content = obj.getString("내용");
                            String start = obj.getString("시작일");
                            String end = obj.getString("종료일");
                            String date = obj.getString("작성일");
                            JSONArray photos = obj.optJSONArray("사진들");

                            // 기간 정보를 제목에 추가
                            String fullTitle = title + "\n기간: " + start + " ~ " + end;
                            LinearLayout card = createCard(fullTitle, content, date, photos);
                            layoutEvent.addView(card);

                            addSpacing(layoutEvent);

                        } catch (Exception e) {
                            Log.e("EventError", "이벤트 파싱 오류: " + e.getMessage());
                        }
                    }
                });

            } catch (Exception e) {
                e.printStackTrace();
                Log.e("EventError", "이벤트 불러오기 실패: " + e.getMessage());
            }
        }).start();
    }

    // 카드 뷰 생성 함수
    private LinearLayout createCard(String title, String content, String date, JSONArray photos) {
        LinearLayout card = new LinearLayout(this);
        card.setOrientation(LinearLayout.VERTICAL);
        card.setPadding(32, 32, 32, 32);
        LinearLayout.LayoutParams cardParams = new LinearLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        card.setLayoutParams(cardParams);

        GradientDrawable background = new GradientDrawable();
        background.setColor(Color.WHITE);
        background.setCornerRadius(20);
        background.setStroke(2, Color.parseColor("#DDDDDD"));
        card.setBackground(background);

        TextView tvTitle = new TextView(this);
        tvTitle.setText("[" + date + "] " + title);
        tvTitle.setTextSize(18);
        tvTitle.setTypeface(null, Typeface.BOLD);
        tvTitle.setTextColor(Color.BLACK);

        TextView tvContent = new TextView(this);
        tvContent.setText(content);
        tvContent.setTextSize(16);
        tvContent.setTextColor(Color.DKGRAY);
        tvContent.setPadding(0, 16, 0, 16);

        card.addView(tvTitle);
        card.addView(tvContent);

        // 이미지가 있을 경우만 추가
        if (photos != null) {
            for (int i = 0; i < photos.length(); i++) {
                try {
                    String url = photos.getString(i);
                    ImageView imageView = new ImageView(this);
                    imageView.setAdjustViewBounds(true);
                    imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);

                    LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams(
                            ViewGroup.LayoutParams.MATCH_PARENT, 500);
                    imgParams.setMargins(0, 0, 0, 16);
                    imageView.setLayoutParams(imgParams);

                    Glide.with(this).load(url).into(imageView);
                    card.addView(imageView);
                } catch (Exception e) {
                    Log.e("ImageLoad", "이미지 로딩 오류: " + e.getMessage());
                }
            }
        }

        return card;
    }

    // 카드 간 여백 추가
    private void addSpacing(LinearLayout layout) {
        View space = new View(this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, 32);
        space.setLayoutParams(params);
        layout.addView(space);
    }
}
