package com.example.smoking;

import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import com.kakao.vectormap.KakaoMap;
import com.kakao.vectormap.KakaoMapReadyCallback;
import com.kakao.vectormap.LatLng;
import com.kakao.vectormap.MapView;
import com.kakao.vectormap.MapLifeCycleCallback;
import com.kakao.vectormap.camera.CameraUpdate;
import com.kakao.vectormap.camera.CameraUpdateFactory;
import com.kakao.vectormap.label.LabelLayer;
import com.kakao.vectormap.label.LabelOptions;
import com.kakao.vectormap.label.LabelStyle;
import com.kakao.vectormap.label.LabelStyles;
import com.kakao.vectormap.label.LabelTextBuilder;
import com.kakao.vectormap.label.LabelTextStyle;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;



public class MainActivity extends AppCompatActivity {
    private MapView mapView;
    private KakaoMap kakaoMap;
    private static final String API_URL = "https://infognu.ansan.ac.kr/~i2151046/smoking/get_spots.php";
    ImageButton FavoriteBtn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        FavoriteBtn = findViewById(R.id.btnFavorite); // 가입하기 버튼 (아이디/비밀번호 찾기 아래)
        EditText searchBar = findViewById(R.id.search_bar);


        searchBar.setOnEditorActionListener((TextView v, int actionId, KeyEvent event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH || actionId == EditorInfo.IME_ACTION_DONE
                    || event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER) {

                String keyword = searchBar.getText().toString().trim();
                if (!keyword.isEmpty()) {
                    searchLocation(keyword);  // 위치 검색 함수 호출
                }
                return true;
            }
            return false;
        });


        // LinearLayout을 찾아서 클릭 리스너 설정 , 흡연습관 버튼을 누르면 메인에서 흡연습관으로 넘어감
        LinearLayout habbitLayout = findViewById(R.id.habbit);
        habbitLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // HabbitActivity로 페이지 전환
                Intent intent = new Intent(MainActivity.this, HabbitActivity.class);
                startActivity(intent);
            }
        });




        // 리뷰 버튼
        FavoriteBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // review로 이동
                Intent intent = new Intent(MainActivity.this, reviewActivity.class);
                startActivity(intent);
            }
        });

        // 설정 버튼
        ImageButton btnSettings = findViewById(R.id.setting_btn);
        btnSettings.setOnClickListener(v -> {
            SettingsFragment settingsFragment = new SettingsFragment();
            settingsFragment.show(getSupportFragmentManager(), "settings");
        });

        LinearLayout reportLayout = findViewById(R.id.report);
        reportLayout.setOnClickListener(v -> {
            ReportFragment reportFragment = new ReportFragment();
            reportFragment.show(getSupportFragmentManager(), "report");
        });


        // 1) MapView 초기화
        mapView = findViewById(R.id.map_view);
        mapView.start(new MapLifeCycleCallback() {
            @Override public void onMapDestroy() { Log.d("KakaoMap","onMapDestroy"); }
            @Override public void onMapError(Exception error) { Log.e("KakaoMap","onMapError",error); }
        }, new KakaoMapReadyCallback() {
            @Override
            public void onMapReady(@NonNull KakaoMap map) {
                kakaoMap = map;

                // 초기 지도 중심 설정 (예: 서울 시청)
                LatLng initialPosition = LatLng.from(37.30852168574192, 126.87658312623842);

                // 2. CameraUpdate 객체 생성 (위치 + 줌레벨)
                CameraUpdate cameraUpdate = CameraUpdateFactory.newCenterPosition(initialPosition, 13); // 줌 레벨은 상황에 맞게 조절

                // 3. 지도 이동 (애니메이션 효과 포함 가능)
                kakaoMap.moveCamera(cameraUpdate); // 애니메이션 없이 바로 이동

                // 2) 마커 아이콘 스타일 정의
                LabelStyle baseStyle = LabelStyle.from(R.drawable.ic_smoking_area)
                        .setTextStyles(
                                LabelTextStyle.from(
                                        28, // 텍스트 크기
                                        Color.parseColor("#222222"),    // 텍스트 색상
                                        2,  // 외곽선 두께
                                        Color.WHITE)    // 외곽선 색상
                        );

                LabelStyles styles = kakaoMap.getLabelManager().addLabelStyles(LabelStyles.from(baseStyle));

                // 3) 레이어 가져오기 (하나의 레이어에 로컬+서버 모두 추가)
                LabelLayer layer = kakaoMap.getLabelManager().getLayer();


                // 4) 로컬 SQLite 데이터 먼저 표시
                showLocalSpots(layer, styles);

                // 5) 서버에서 흡연구역 가져와서 표시
                fetchServerSpots(layer, styles);
            }
        });
    }

    private void searchLocation(String keyword) {
        String apiKey = "5f4828ec61dde2e3465613a8c117bb90"; // 여기에 본인의 REST 키 넣기
        String url = "https://dapi.kakao.com/v2/local/search/keyword.json?query=" + keyword;

        RequestQueue queue = Volley.newRequestQueue(this);

        StringRequest request = new StringRequest(Request.Method.GET, url,
                response -> {
                    try {
                        JSONObject json = new JSONObject(response);
                        if (json.getJSONArray("documents").length() > 0) {
                            JSONObject first = json.getJSONArray("documents").getJSONObject(0);
                            double lng = first.getDouble("x");
                            double lat = first.getDouble("y");

                            LatLng newPos = LatLng.from(lat, lng);
                            CameraUpdate update = CameraUpdateFactory.newCenterPosition(newPos, 14);
                            kakaoMap.moveCamera(update);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                },
                error -> Log.e("KakaoSearch", "검색 실패", error)
        ) {
            @Override
            public Map<String, String> getHeaders() {
                Map<String, String> headers = new HashMap<>();
                headers.put("Authorization", "KakaoAK " + apiKey);
                return headers;
            }
        };

        queue.add(request);
    }


    /** 로컬 SQLite 흡연구역 표시 */
    private void showLocalSpots(LabelLayer layer, LabelStyles styles) {
        DBHelper db = new DBHelper(this);
        Cursor c = db.getAllSmokingSpots();
        while (c.moveToNext()) {
            double lat = c.getDouble(c.getColumnIndexOrThrow("위도"));
            double lng = c.getDouble(c.getColumnIndexOrThrow("경도"));
            Log.d("Marker", "위도: " + lat + ", 경도: " + lng);

            LatLng pos = LatLng.from(lat, lng);

            LabelOptions opts = LabelOptions.from(pos)
                    .setStyles(styles);
            layer.addLabel(opts);
        }
        c.close();
    }

    /** 서버 PHP → JSON → 마커 표시 */
    private void fetchServerSpots(LabelLayer layer, LabelStyles styles) {
        RequestQueue queue = Volley.newRequestQueue(this);
        JsonArrayRequest req = new JsonArrayRequest(
                Request.Method.GET,
                API_URL,
                null,
                response -> {
                    for (int i = 0; i < response.length(); i++) {
                        try {
                            JSONObject obj = response.getJSONObject(i);
                            double lat = obj.getDouble("위도");
                            double lng = obj.getDouble("경도");
                            String address = obj.getString("주소");

                            Log.d("Marker", "위도: " + lat + ", 경도: " + lng);

                            LatLng pos = LatLng.from(lat, lng);

                            LabelOptions opts = LabelOptions.from(pos)
                                    .setStyles(styles)
                                    .setTexts(new LabelTextBuilder().setTexts(address));

                            layer.addLabel(opts);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                error -> Log.e("Volley","fetch error",error)
        );
        queue.add(req);
    }

    @Override protected void onResume() {
        super.onResume();
        mapView.resume();
    }
    @Override protected void onPause()  {
        super.onPause();
        mapView.pause();
    }





}
