package com.example.smoking;

import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.spans.DotSpan;
import com.prolificinteractive.materialcalendarview.CalendarDay;

import java.util.HashSet;
import java.util.Set;

public class DotDecorator implements DayViewDecorator {

    private final HashSet<CalendarDay> datesWithRecords;
    private final int color;

    public DotDecorator(Set<CalendarDay> dates, int color) {
        this.datesWithRecords = new HashSet<>(dates);
        this.color = color;
    }

    @Override
    public boolean shouldDecorate(CalendarDay day) {
        return datesWithRecords.contains(day);
    }

    @Override
    public void decorate(DayViewFacade view) {
        view.addSpan(new DotSpan(10, color)); // 점 크기와 색상 지정
    }
}