package com.example.smoking;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.bumptech.glide.Glide;

public class DetailActivity extends AppCompatActivity {

    private TextView titleText, subtitleText;
    private ImageView imageThumb;
    private Button btnWriteReview;

    private int smokingAreaId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_detail);

        // XML에 정의된 뷰 연결
        titleText = findViewById(R.id.titleText);
        subtitleText = findViewById(R.id.subtitleText);
        imageThumb = findViewById(R.id.imageThumb);
        btnWriteReview = findViewById(R.id.btnWriteReview);

        // 인텐트에서 데이터 받기
        Intent intent = getIntent();
        smokingAreaId = intent.getIntExtra("id", -1);

        // 데이터 잘 받았는지 토스트로 확인
        Toast.makeText(this, "흡연구역 ID: " + smokingAreaId, Toast.LENGTH_SHORT).show();

        String name = intent.getStringExtra("name");
        String imageUrl = intent.getStringExtra("image_url");

        // UI에 데이터 표시
        titleText.setText(name);
        subtitleText.setText("흡연장 상세 정보");

        if (imageUrl != null && !imageUrl.isEmpty()) {
            Glide.with(this)
                    .load(imageUrl)
                    .placeholder(R.drawable.logo)
                    .into(imageThumb);
        } else {
            imageThumb.setImageResource(R.drawable.logo);
        }

        // 리뷰 작성 버튼 클릭 시 ReviewWriteActivity로 이동
        btnWriteReview.setOnClickListener(v -> {
            Intent writeIntent = new Intent(DetailActivity.this, ReviewWriteActivity.class);
            writeIntent.putExtra("id", smokingAreaId);  // 흡연구역 ID 전달
            startActivity(writeIntent);
        });
    }
}
