// DBHelper.java
package com.example.smoking;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DBHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "users.db"; // 데이터베이스 이름
    private static final int DATABASE_VERSION = 1; // 데이터베이스 버전

    public DBHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION); // 부모 클래스 생성자 호출
    }

    // 데이터베이스 생성 시 호출되는 메서드
    @Override
    public void onCreate(SQLiteDatabase db) {
        // 회원 테이블 생성 SQL 쿼리
        String CREATE_USERS_TABLE = "CREATE TABLE 회원 (" +
                "아이디 VARCHAR(50) NOT NULL, " +
                "비밀번호 VARCHAR(255) NOT NULL, " +
                "이름 VARCHAR(50) NOT NULL, " +
                "닉네임 VARCHAR(50) NOT NULL, " +
                "이메일 VARCHAR(100) NOT NULL, " +
                "연락처 VARCHAR(20), " +
                "즐겨찾기 TEXT, " +
                "PRIMARY KEY (아이디))";
        db.execSQL(CREATE_USERS_TABLE);

        // ✅ 흡연구역 테이블 생성 추가
        String CREATE_SPOTS_TABLE = "CREATE TABLE 흡연구역 (" +
                "구역ID INTEGER PRIMARY KEY AUTOINCREMENT, " +
                "주소 TEXT NOT NULL, " +
                "위도 REAL NOT NULL, " +
                "경도 REAL NOT NULL, " +
                "별점 FLOAT DEFAULT 0, " +
                "리뷰 TEXT, " +
                "사진URL TEXT, " +
                "즐겨찾기수 INTEGER DEFAULT 0)";

        db.execSQL(CREATE_SPOTS_TABLE);


        // 초기 사용자 데이터 삽입 (테스트용)
        db.execSQL("INSERT INTO 회원 (아이디, 비밀번호, 이름, 닉네임, 이메일) VALUES ('testUser', 'password123', '홍길동', '테스트', 'test@example.com')");
        db.execSQL("INSERT INTO 흡연구역 (주소, 위도, 경도) VALUES ('서울역 흡연구역', 37.554722, 126.970833)");
    }

    // 데이터베이스 업그레이드 시 호출되는 메서드
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // 테이블 삭제 후 새로 생성
        db.execSQL("DROP TABLE IF EXISTS 회원");
        onCreate(db);
    }

    // 아이디와 비밀번호로 로그인 검사
    public boolean validateLogin(String 아이디, String 비밀번호) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT * FROM 회원 WHERE 아이디 = ? AND 비밀번호 = ?", new String[]{아이디, 비밀번호});

        if (cursor.moveToFirst()) {
            cursor.close();
            return true;  // 로그인 성공
        } else {
            cursor.close();
            return false;  // 로그인 실패
        }
    }
    // ✅ 여기 추가!
    public Cursor getAllSmokingSpots() {
        SQLiteDatabase db = this.getReadableDatabase();
        return db.rawQuery("SELECT * FROM 흡연구역", null);
    }
}

