# ✅ GitHub 협업 가이드

난 명령어 VScode에 터미널 기능이 있어서 그거 쓰는디 너희도 그냥 VScode 써<br>
https://git-scm.com/downloads/win<br>
git다운로드 링크 여기 들어가서 다운 먼저 해야혀

### [깃허브를 사용해야하는 이유?](#깃허브를-사용해야하는-이유-1)

 <br>
 
### [작업 시작할때](#작업-순서-가이드)

 <br>
 
### [수정 해야할때](#푸시한-브랜치-수정-가이드)

 <br>

### [오류메세지 정리](#오류메세지-정리-1)

<br>
 
### [용어 정리](#-용어-설명)

---

<br><br><br><br>

<br><br><br><br>

<br><br><br><br>

---

# 작업 순서 가이드

 <br><br>

## 1. 레포지토리 클론 (**최초 1회만**)
**최초 1회만** 실행하는 거야  우리는 https://github.com/kkambbab/Capstone.git 이거임

<br>

```bash
git clone https://github.com/프로젝트_소유자_ID/레포지토리명.git
cd 레포지토리명 # 이거 꼭 확인
```

<br>

- 깃허브에 올라가있는 레포지토리를 내 컴퓨터로 복사해오는거야(첫번째 명령어) <br>
- 그 뒤에 **cd로 꼭 복사해온 레포지토리**로 이동해야해(두번째 명령어) <br>

<br>

### [레포지토리란?](#-repository-레포지토리)    [클론이란?](#-clone-클론)


<br>
 

## 2. 작업 시작 전 (매번 작업 전)

```bash
git checkout main
git pull origin main
git checkout -b feature/작업명  # 작업명은 현재 하는 작업 이름

# 한글로 적어도 괜찮으니 반드시 현재하는 작업이름으로 지정해줘야함 반드시
```

<br>
 
- main브랜치에 변경사항이 있는지 확인하고(첫번째 명령어) <br>
- main에 있는 파일을 내 컴퓨터로 복사해오는거야(두번째 명령어) <br>
- 그 뒤에 "작업명"의 이름을 가진 너만의 브랜치를 생성해.(세번째 명령어) (너만의 작업폴더 생성) <br>

<br>
 
### [checkout이란?](#-checkout-체크아웃)    [pull이란?](#-pull-풀)    [브랜치란?](#-branch-브랜치)


<br>
 
## 3. 기능 개발
```bash
기능 개발 하셈 ㅇㅇ 기능개발 하기 전에 cd로 복사해온 리포지토리에 들어와있는지 꼭 확인해
```

<br>
 

## 4. 커밋 (기능 개발 후)

```bash
git add .
git commit -m "작업 내용 요약"

# 작업 내용 요약 안에는 설명문(어떤작업했는지) 작성
```

<br>
 
- 커밋(저장)할 파일을 지정해준 뒤에(첫번째 명령어) <br>
- 지정해준 파일을 커밋시켜(두번째 명령어) <br>
- `"작업 내용 요약"` 부분엔 네가 한 작업을 간단히 적어주면 돼. <br>
- **커밋은 자주 할수록 좋아!** 보통 파일 한개 수정할때마다 한번씩?

<br>
 
### [add란?](#-add-애드)    [commit이란?](#-commit-커밋)


<br>
 

## 5. 브랜치 푸시

```bash
git pull origin main # 파일들을 최신화 시킴 (2번에서 했던거)

git push origin feature/작업명
# 2번에서 적었던 작업명 그대로 작성

# 작업명(브랜치 이름)이 기억이 안난다면?

git branch --show-current # 현재 작업중인 브랜치 확인
```

<br>
 
**현재 브랜치를 원격 저장소(GitHub)에 업로드(push)** 하는 명령어야.(두번째 명령어) <br>
- `feature/작업명`은 네가 만든 브랜치 이름이야 <br>
- 밑에 있는건 지금 내가 **어떤 브랜치에서 작업하고 있는지 확인**하는 명령어야.(세번째 명령어) <br>
- 브랜치 이름이 기억 안날때 쓰는거여 <br>

<br>
 
### [push란?](#-push-푸시)


<br>
 

## 6. Pull Request(PR) 생성

- GitHub 웹사이트에서 `Pull requests` 클릭
- `base: main ← compare: feature/작업명`
- 리뷰 요청 → 승인되면 merge

### 자세한 설명

✅ **PR 만드는 순서**

1. **GitHub에서 작업한 브랜치로 이동한다**
   - GitHub에서 해당 레포지토리(저장소)로 들어간다.
   - `<> Code` 탭 클릭
   - 브랜치 드롭다운에서 → `feature/작업명` 브랜치를 선택한다
   - ![Image](https://github.com/user-attachments/assets/ce2f2e2b-92fb-4ca0-9fba-e03ce0e755cd)
   - 이게 그 브랜치 드롭다운임


2. **"Pull requests" 메뉴 클릭**
   - 상단 탭에서 **Pull requests** 클릭
   - **"New Pull Request"** 버튼 클릭

3. **브랜치 선택**
   - `base`: `main`
   - `compare`: `feature/작업명`

4. **제목과 설명 작성**
   - 제목 예시: ✨ 장바구니 기능 추가
   - 설명 예시:
     ```markdown
     - 상품 추가/삭제 기능 구현
     - 수량 조절 기능 추가
     - 레이아웃 일부 개선
     ```

5. **리뷰어 지정** (필요한 경우)
   - `Reviewers`나 `Assignees`에 팀원 지정

6. **"Create Pull Request" 클릭!**

7. **팀원이 리뷰 → 승인되면 Merge 완료! 🎉**

---

📌 **기억해 두기!**
- PR은 바로 `main` 브랜치에 반영되는 걸 막아주는 **보호막**이야
- 협업 중 충돌 방지, 리뷰 체크, 기록 추적에 아주 유용해
- **PR 없이 직접 main에 작업하지 말자!**
- **제발 제발 제발 제발 제발 제발 제발 제발 제발 제발 제발 제발 제발 제발 PR 없이 직접 main에 작업하지 말자!**


### [Pull Request란?](#-pull-request-PR)    [merge란?](#-merge-머지)


<br>
 

## 7. 작업 완료 후 (선택)

```bash
git checkout main
git pull origin main
git branch -d feature/작업명
git push origin --delete feature/작업명
```

### [브랜치 삭제란?](#-branch-delete-브랜치-삭제) <br>
✅ git checkout main
역할: 현재 브랜치를 main 브랜치로 전환
언제?: 새 작업을 시작하거나, 작업 후 병합 등 main 브랜치에서 작업할 때 사용

💡 브랜치를 바꾸기 전에는 반드시 커밋 or stash를 해야 변경 사항이 날아가지 않음

✅ git pull origin main
역할: 원격 저장소(origin)의 최신 main 브랜치 내용을 내 로컬에 가져옴
언제?: 작업을 시작하기 전에 항상!

💡 다른 팀원이 푸시한 변경사항을 가져와서 최신 상태를 유지하는 것.

✅ git branch -d feature/작업명
역할: 로컬에서 feature/작업명 브랜치를 삭제
언제?: 해당 브랜치 작업이 끝나고 main 브랜치에 병합한 후

💡 -d 옵션은 병합된 브랜치만 삭제 가능.
병합되지 않은 브랜치를 강제로 지우려면 -D를 사용.

✅ git push origin --delete feature/작업명
역할: GitHub(원격 저장소)에 있는 해당 브랜치를 삭제
언제?: PR이 머지되고, 더 이상 브랜치가 필요 없을 때

💡 정리차원에서 원격 브랜치도 함께 삭제하면 저장소가 깔끔해짐

---

<br><br><br><br><br><br><br>

---

# 깃허브를 사용해야하는 이유
- 깃허브는 각자의 저장공간을 생성하여 따로 작업하고, 합치기 편리하다 <br>
- 언제 어떤 변경사항이 있었는지 추적이 편리하고, 과거의 코드로 돌아갈 수 있다. <br><br><br>

### Git 사용방식 이해하기 <br>
Git은 분산 저장소 방식으로 버전을 관리한다. <br>
로컬저장소(PC, Git)과 원격저장소(GitHub) 양 쪽에서 관리를 할 수 있으므로 서버 단에 문제가 생기더라도 로컬에서 작업할 수 있어 지속적인 협업이 가능한 것이다. <br>
다시 말해, 로컬에서 깃(Git)을 이용해 실제 개발과 버전 관리를 진행하고 깃헙(Github)에 반영본을 업데이트하는 식으로 작업이 진행된다. <br><br><br>
 
### 깃허브로 버전관리 하는 법 <br>
1) 로컬에 저장소를 생성한다
2) 깃허브 서버와 연결한다
3) 서버에서 전체 내용을 가져온다 (clone)
4) 작업이 진행된 이후에는 일부 변경된 내용만 가져온다 (fetch)
5) 필요에 따라 다른 서버의 내용을 가져올 수도 있다 (fork)
6) 추가작업은 브랜치(branch)를 따서 진행(checkout)하며 파일의 변화는 스냅샷(snapshot)으로 저장한다.
7) 새롭게 추가한 작업이 완성되면 마스터 브랜치와 병합 (merge) 한다
8) 개발이 완료되면 완료된 파일들을 스테이징 영역에 추가 (add) 한다
9) 내용이 안전하게 추가되었다면 로컬에 반영 (Commit) 한다. <br><br><br>
출처: https://y-oni.tistory.com/84 [욘블로그(Yon-Blog):티스토리]

---

<br><br><br><br><br><br><br>

---

# 푸시한 브랜치 수정 가이드

 <br>
 
### 1. 작업하려는 브랜치로 이동
```bash
git checkout feature/브랜치이름
```

 <br>
 
### 2. 파일을 수정

<br>
 
### 3. 수정한 파일 커밋
```bash
git add .
git commit -m "수정 내용"
```

<br>
 
### 4. 수정한 내용을 원격 저장소에 푸시
```bash
git push origin feature/작업명
```

<br> <br>

## 💡 커밋 수정 가이드
 - **커밋 메시지만 수정:**
```bash
git commit --amend
git push --force origin feature/작업명
```
 - **최근 커밋 삭제:**
```bash
git reset --hard HEAD~1
git push --force origin feature/작업명
```
- **되돌리는 커밋 만들기:**
```bash
git revert HEAD
git push origin feature/작업명
```
 <br><br>

## 푸시된 브랜치 다시 들어가기
1. 브랜치 목록 확인:
```bash
git branch -a
```
2. 브랜치 전환
- 로컬에 있는 경우:
```bash
git checkout feature/브랜치이름
```
- 로컬에 없는 경우 (처음 접근 시):
```bash
git checkout -b 브랜치이름 origin/브랜치이름
```

3. 현재 브랜치 확인:
```bash
git branch
git status
```
---

 <br><br><br><br><br>

---
# 오류메세지 정리

 <br><br>

<sub>────────────────────────────</sub>
## changes no staged for commit
### 원인
- git add 로 어떤 변경사항을 커밋할지 지정해주지 않아서 그래 <br> <br>

### 해결방법

1. 수정파일 전체 커밋대상으로 지정
```bash
git add .
```
 <br>

2. 수정파일 따로 지정하고 싶을때

수정된 파일 확인
```bash
git status
```
커밋할 파일 지정
```bash
git add 파일명
```

 <br><br><br>

<sub>────────────────────────────</sub>
## error: Your local changes to the following files would be overwritten by merge:

```bash
error: Your local changes to the following files would be overwritten by merge:
    파일명
Please commit your changes or stash them before you merge.
Aborting
```

<br>

### 원인

- 로컬에서 파일을 수정했는데 **커밋하지 않은 상태에서** `git pull`, `git merge`, `git checkout` 등을 하려고 했을 때 발생
- Git은 **수정된 파일이 덮어써지는 걸 막기 위해** 병합을 중단시켜

<br>

### 해결 방법

### 1. **수정한 내용을 커밋하기**
```bash
git add .
git commit -m "작업 내용 커밋"
```
→ 작업을 저장한 다음 병합을 다시 시도!

<br>

### 2. **수정한 내용을 임시로 숨기기 (Stash)**
```bash
git stash
```
→ 수정 내용들을 임시 저장소에 넣어두고 merge 진행 가능

그 후:
```bash
git merge origin/main   # 또는 git pull
git stash pop           # 숨겨둔 내용 다시 가져오기
```

---

### 3. **정말 버려도 되는 변경이라면 리셋**
```bash
git reset --hard
```
> ⚠️ 이 명령은 **모든 미커밋 변경 사항을 삭제**하니 주의!

 <br><br><br>

<sub>────────────────────────────</sub>

## 오류: author identity unknown
### 원인

Git이 커밋한 사람 정보를 몰라서 생기는 오류입니다.

```
Author identity unknown

*** Please tell me who you are.

Run

  git config --global user.email "you@example.com"
  git config --global user.name "Your Name"

to set your account's default identity.
```

---

### 해결 방법

**전역(Global) 설정:**
```bash
git config --global user.name "당신의 이름"
git config --global user.email "당신의 이메일"
```

예시:
```bash
git config --global user.name "Hong Gildong"
git config --global user.email "hong@ansan.ac.kr"
```

---

**특정 프로젝트에만 적용하고 싶다면(Local):**
```bash
git config user.name "프로젝트용 이름"
git config user.email "프로젝트용 이메일"
```

---

**설정 확인하기:**
```bash
git config --global --list
```

이제 다시 커밋하면 오류 없이 진행됩니다!
---

<br><br><br><br><br><br><br>

---

# 📚 용어 설명

 <br> <br>

### 🔤 VS Code Git 상태 아이콘 설명 (파일 오른쪽에 뜨는거)

| 표시 | 의미 | 상태 |
|----------|--------------|----------|
M |	Modified |	파일이 수정되었지만 아직 커밋되지 않음 |
U |	Untracked |	Git이 아직 추적하지 않는 새 파일 (add 안 된 상태) |
A |	Added |	새로 추가되어 git add는 됐지만 커밋은 안 된 상태 |
D |	Deleted | 내용이 삭제되었고, 삭제 상태가 Git에 반영되어야 함 |

 <br> <br>

### 📦 Repository (레포지토리)
프로젝트의 모든 파일과 이력을 저장해두는 공간입니다.  
코드를 정리하고 공유하는 **중심 폴더**라고 생각하면 됩니다.

---

### 🧭 Clone (클론)
GitHub에 있는 프로젝트를 **내 컴퓨터로 복사**해오는 작업입니다.  
처음 시작할 때 한 번만 하면 됩니다.

---

### 🔄 Checkout (체크아웃)
작업할 브랜치를 **선택해서 전환**하는 명령어입니다.  
예: `main`에서 새 브랜치로 이동하거나, 기존 브랜치로 돌아갈 때 사용합니다.

---

### 📥 Pull (풀)
다른 사람이 올린 최신 변경사항을 **내 컴퓨터로 가져오는 작업**입니다.  
항상 작업 전에 실행해서 최신 상태를 유지하는 것이 좋습니다.

---

### 🌿 Branch (브랜치)
새로운 기능을 만들거나 수정을 테스트할 때,  
기존 코드(main)는 그대로 두고 **별도로 작업할 수 있는 분리된 공간**입니다.

---

### ➕ Add (애드)
수정한 파일을 커밋할 준비를 하는 단계입니다.  
Git에게 “이 파일 저장할게요”라고 알려주는 명령입니다.

---

### 💾 Commit (커밋)
변경사항을 로컬 저장소에 **저장하면서 설명을 남기는 작업**입니다.  
한 가지 작업이 끝났을 때마다 커밋을 남기는 것이 좋습니다.

---

### 🚀 Push (푸시)
내가 작업한 내용을 GitHub 저장소로 **업로드하는 명령어**입니다.  
팀원들과 공유하기 위해 꼭 필요한 단계입니다.

---

### 🔀 Pull Request (PR)
작업한 내용을 main 브랜치에 **합쳐달라고 요청하는 절차**입니다.  
코드 리뷰를 통해 확인받고, 문제가 없으면 병합됩니다.

---

### 🔗 Merge (머지)
Pull Request가 승인되면, **작업한 내용을 main에 반영**하는 과정입니다.

---

### 🧹 Branch Delete (브랜치 삭제)
작업이 끝난 브랜치는 정리 차원에서 **삭제하는 것이 좋습니다.**  
로컬과 원격 저장소 모두에서 지워줍니다.
