<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    die("잘못된 접근입니다.");
}
$user_id = $_SESSION['user_id'];
?>
<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8">
  <title>비밀번호 재설정</title>
  <style>
    body {
      background-color: #f8f9fa;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      margin: 0;
      padding: 0;
    }

    .container {
            height: 100%;
            max-width: 400px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
          }

    h2 {
      text-align: center;
      margin-bottom: 30px;
      font-size: 1.5em;
      color: #333;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: bold;
      font-size: 0.95em;
      color: #333;
    }

    input {
      width: 100%;
      padding: 12px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 1em;
      transition: border-color 0.3s, box-shadow 0.3s;
    }

    input:focus {
      border-color: #007bff;
      box-shadow: 0 0 5px rgba(0, 123, 255, 0.4);
      outline: none;
    }

    button {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-size: 1em;
      cursor: pointer;
      transition: background-color 0.2s ease;
    }

    button:hover {
      background-color: #0056b3;
    }

    @media (max-width: 480px) {
      .container {
        margin: 40px 16px;
        padding: 30px 16px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>새 비밀번호 입력</h2>
    <form action="reset-password-process.php" method="POST">
      <input type="hidden" name="user_id" value="<?= htmlspecialchars($user_id) ?>">
      
      <label for="new_password">새 비밀번호</label>
      <input type="password" id="new_password" name="new_password" required>
      
      <label for="confirm_password">비밀번호 확인</label>
      <input type="password" id="confirm_password" name="confirm_password" required>
      
      <button type="submit">비밀번호 변경</button>
    </form>
  </div>
</body>
</html>
