<?php
require_once('../../includes/db_connect.php');
require_once('../../includes/islogin.php');

if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 0) {
    echo '<script>alert("일반 사용자만 접근 가능합니다."); window.location.href = "/Capstone/main.php";</script>';
    exit;
}

$user_id = $_SESSION['user_id'];

// 사용자 정보 불러오기
$sql = "SELECT username, student_id, current_mileage FROM Users WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $student_id, $current_mileage);
$stmt->fetch();
$stmt->close();

// 사용하지 않은 쿠폰 수 조회
$sql_coupon = "SELECT COUNT(*) FROM UserCoupons WHERE user_id = ? AND used = 0";
$stmt_coupon = $conn->prepare($sql_coupon);
$stmt_coupon->bind_param("i", $user_id);
$stmt_coupon->execute();
$stmt_coupon->bind_result($coupon_count);
$stmt_coupon->fetch();
$stmt_coupon->close();
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>마이페이지</title>
    <link 
      rel="stylesheet" 
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" 
      integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" 
      crossorigin="anonymous" 
      referrerpolicy="no-referrer" 
    />
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            font-family: sans-serif;
            display: flex;
            justify-content: center;
        }

        .container {
            width: 100%;
            max-width: 420px;
            height: 100vh; /* min-height -> height로 변경 */
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            padding-bottom: 60px; /* 하단 네비 공간 확보 */
            box-sizing: border-box;
        }

        .mypage {
            flex-grow: 1;
            overflow-y: auto;
        }

        .header-fixed {
            position: sticky;
            top: 0;
            background-color: white;
            z-index: 10;
            padding: 30px 20px 10px;
            text-align: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }

        .header-fixed h2 {
            margin: 0;
            font-size: 24px;
        }

        .header-fixed .student {
            color: gray;
            margin-top: 5px;
            font-size: 14px;
        }

        .header-fixed hr {
            margin: 20px auto 10px;
            border: none;
            border-top: 1px solid #ccc;
        }

        .header-fixed .mileage {
            color: #007bff;
            margin-top: 8px;
            font-size: 15px;
            font-weight: bold;
        }
        .header-fixed .mileage i {
            margin-right: 4px;
        }

        .mypage ul {
            list-style: none;
            padding: 0 20px;
            margin: 0;
        }

        .mypage li {
            margin: 30px 0;
            font-size: 19px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .mypage li a {
            color: black;
            text-decoration: none;
            flex-grow: 1;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .coupon-item {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .mypage li .count {
            color: #007bff;
            font-weight: bold;
            min-width: 20px;
            text-align: right;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 420px;
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #eee;
            background-color: white;
            box-sizing: border-box;
            z-index: 1000;
        }

        .bottom-nav a {
            color: #555;
            font-size: 1.5em;
            text-decoration: none;
            padding: 5px 10px;
            transition: color 0.2s;
        }

        .bottom-nav a:hover,
        .bottom-nav a.active {
            color: #007bff;
        }
    </style>

    <script>
        function logoutConfirm() {
            if (confirm("로그아웃 하시겠습니까?")) {
                location.href = '../../auth/logout.php';
            }
        }
    </script>
</head>
<body>
<div class="container">
    <div class="mypage">
        <div class="header-fixed">
            <h2><?= htmlspecialchars($username) ?></h2>
            <div class="student"><?= htmlspecialchars($student_id) ?></div>
            <div class="mileage"><i class="fa-solid fa-coins"></i> 보유 마일리지: <?= htmlspecialchars(number_format($current_mileage)) ?> P</div>
            <hr>
        </div>

        <ul>
            <li><a href="#"><i class="fa-solid fa-pen-to-square"></i>리뷰관리</a></li>
            <li><a href="../order/payment-complete.html"><i class="fa-solid fa-credit-card"></i>결제관리</a></li>
            <li><a href="../order/payment-confirm.html"><i class="fa-solid fa-calendar-check"></i>예약확인</a></li>
            <li>
                <a href="coupon.php" class="coupon-item">
                    <i class="fa-solid fa-ticket"></i>
                    할인쿠폰<span class="count"><?= $coupon_count ?></span>
                </a>
            </li>
            <li><a href="../../admin/coupon/coupon.html"><i class="fa-solid fa-bullhorn"></i>진행중인 이벤트</a></li>
            <li><a href="../../admin/password-change-form.php"><i class="fa-solid fa-gear"></i>비밀번호 변경</a></li>
            <li>
                <a href="../../auth/delete_account.php">
                    <i class="fa-solid fa-times"></i>회원 탈퇴
                </a>
            </li>
            <li><a href="../../app/appSettings.php"><i class="fa-solid fa-gear"></i>설정</a></li>
            <li><a href="javascript:void(0);" onclick="logoutConfirm()"><i class="fa-solid fa-right-from-bracket"></i>로그아웃</a></li>
        </ul>
    </div>

    <nav class="bottom-nav">
        <a href="../../main.php"><i class="fa-solid fa-house"></i></a>
        <a href="dibs.php"><i class="fa-solid fa-heart"></i></a>
        <a href="../order/orderlist.php"><i class="fa-solid fa-receipt"></i></a>
        <a href="../../auth/redirect-mypage.php" class="active"><i class="fa-solid fa-user"></i></a>
    </nav>
</div>
</body>
</html>
