<?php
require_once "../../includes/db_connect.php";
require_once "../../includes/islogin.php";

$userId = $_SESSION['user_id'];

$favorites = [];

$sql = "SELECT
            r.restaurant_id,
            r.name,
            r.image_url,
            r.opening_hours,
            AVG(rev.rating) AS avg_rating,
            COUNT(DISTINCT rev.review_id) AS review_count
        FROM
            Restaurants r
        JOIN
            User_favorites uf ON r.restaurant_id = uf.restaurant_id
        LEFT JOIN
            Reviews rev ON r.restaurant_id = rev.restaurant_id
        WHERE
            uf.user_id = ?
        GROUP BY 
            r.restaurant_id, r.name, r.image_url, r.opening_hours";

$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $favorites[] = $row;
    }
    $stmt->close();
} else {
    error_log("찜 목록 조회 실패 (User ID: $userId): " . $conn->error);
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>찜한 가게</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        html, body {
            height: 100%;
            margin: 0;
            font-family: sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            height: 100%;
            max-width: 400px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 15px;
            height: 70px;
            box-sizing: border-box;
            border-bottom: 1px solid #ddd;
        }
        .header h1 {
            display: flex;
            align-items: center;
            font-size: 1.2em;
            margin: 0;
            flex-grow: 1;
            justify-content: center;
        }
        .cart-link {
            text-decoration: none;
            color: inherit;
            display: flex;
            align-items: center;
        }
        .cart-icon {
            font-size: 1.5em;
            color: #555;
            cursor: pointer;
        }
        .content-list {
            flex: 1;
            overflow-y: auto;
            padding: 0 15px;
        }
        a.restaurant-item {
            text-decoration: none;
            color: inherit;
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #eee;
        }
        .restaurant-item img {
            width: 80px;
            height: 80px;
            border-radius: 8px;
            margin-right: 15px;
            object-fit: cover;
            background-color: #eee;
        }
        .restaurant-info {
            flex-grow: 1;
            display: flex;
            justify-content: space-between;
        }
        .restaurant-info .details h2 {
            font-size: 1.1em;
            margin: 0 0 5px 0;
        }
        .restaurant-info .details p {
            font-size: 0.9em;
            margin: 0;
        }
        .restaurant-info .rating {
            display: flex;
            flex-direction: column;
            align-items: flex-end;
            min-width: 60px;
        }
        .restaurant-info .rating .star {
            font-size: 1em;
            color: #ffc107;
            margin-bottom: 5px;
        }
        .restaurant-info .rating .reviews {
            font-size: 0.9em;
        }
        .bottom-nav {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #eee;
            background-color: white;
            flex-shrink: 0;
        }
        .bottom-nav a {
            color: #555;
            font-size: 1.5em;
            text-decoration: none;
            padding: 5px 10px;
            transition: color 0.2s;
        }
        .bottom-nav a:hover,
        .bottom-nav a.active {
            color: #007bff;
        }
        .no-favorites { padding: 20px; text-align: center; color: #777; }
    </style>
</head>

<body>
    <div class="container">
        <header class="header">
            <h1>찜한 가게</h1>
            <a href="../order/cart.php" class="cart-link"> <i class="fas fa-shopping-cart cart-icon"></i></a>
        </header>

        <div class="content-list">
        <?php if (empty($favorites)): ?>
            <div class="no-favorites">찜한 가게가 없습니다.</div>
        <?php else: ?>
            <?php foreach ($favorites as $restaurant): ?>
                <?php
                    $restaurantId = htmlspecialchars($restaurant['restaurant_id']);
                    $finalUrl = "../menu/menulist.php?restaurant_id=" . $restaurantId;
                ?>
                <a href="<?= $finalUrl ?>" class="restaurant-item">
                    <img src="<?= htmlspecialchars($restaurant['image_url'] ?? '../assets/images/default_store.png'); ?>" alt="<?= htmlspecialchars($restaurant['name']); ?> 로고">
                    <div class="restaurant-info">
                        <div class="details">
                            <h2><?= htmlspecialchars($restaurant['name']); ?></h2>
                            <p><?= htmlspecialchars($restaurant['opening_hours'] ?? '영업시간 정보 없음'); ?></p>
                        </div>
                        <div class="rating">
                            <span class="star">
                                <i class="fas fa-star"></i> <?= ($restaurant['review_count'] > 0) ? htmlspecialchars(number_format($restaurant['avg_rating'], 1)) : '0.0'; ?>
                            </span>
                            <span class="reviews">(<?= htmlspecialchars($restaurant['review_count'] ?? '0'); ?>)</span>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
        </div>

        <nav class="bottom-nav">
            <a href="../../main.php"><i class="fas fa-home"></i></a>
            <a href="dibs.php" class="active"><i class="fas fa-heart"></i></a>
            <a href="../order/orderlist.php"><i class="fas fa-receipt"></i></a>
            <a href="../../auth/redirect-mypage.php"><i class="fas fa-user"></i></a>
        </nav>
    </div>
</body>
</html>
