<?php
require_once '../../includes/db_connect.php';

$restaurant_id = $_GET['restaurant_id'] ?? 1; // 기본값 1, 주소: store_detail.php?id=2

// 기본 식당 정보
$sql = "SELECT * FROM Restaurants WHERE restaurant_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $restaurant_id);
$stmt->execute();
$restaurant = $stmt->get_result()->fetch_assoc();

// 추가 정보
$info_sql = "SELECT * FROM Restaurants_info WHERE restaurant_id = ?";
$info_stmt = $conn->prepare($info_sql);
$info_stmt->bind_param("i", $restaurant_id);
$info_stmt->execute();
$info = $info_stmt->get_result()->fetch_assoc();

// 리뷰 수, 별점 평균
$review_sql = "SELECT COUNT(*) as review_count, ROUND(AVG(rating), 1) as avg_rating FROM Reviews WHERE restaurant_id = ?";
$review_stmt = $conn->prepare($review_sql);
$review_stmt->bind_param("i", $restaurant_id);
$review_stmt->execute();
$review_data = $review_stmt->get_result()->fetch_assoc();

// 찜 수
$dibs_sql = "SELECT COUNT(*) as dibs_count FROM User_favorites WHERE restaurant_id = ?";
$dibs_stmt = $conn->prepare($dibs_sql);
$dibs_stmt->bind_param("i", $restaurant_id);
$dibs_stmt->execute();
$dibs_data = $dibs_stmt->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="ko">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>가게상세페이지</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
  <style>
    html,
    body {
      height: 100%;
      margin: 0;
    }

    .container {
      height: 100%;
      display: flex;
      flex-direction: column;
      max-width: 400px;
      margin: 0 auto;
    }

    .app-container {
      max-width: 500px;
      height: 100%;
      margin: 0 auto;
      display: flex;
      flex-direction: column;
    }

    .main-content {
      flex: 1;
      overflow-y: auto;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 10px;
      border-bottom: 1px solid #ddd;
    }

    .back-button {
      text-decoration: none;
      color: #555;
      font-size: 1.5em;
      display: flex;
      align-items: center;
      padding: 5px 10px;
      cursor: pointer;
      border-radius: 50%;
      transition: background 0.2s;
    }

    .header .back-button:hover {
      background: #f0f0f0;
    }

    .store-info {
      padding: 20px;
      font-size: 1.1em;
    }

    .store-info p {
      margin: 5px 0;
    }

    .store-description,
    .certifications,
    .statistics,
    .business-info {
      padding: 20px;
    }

    .section-title {
      padding: 10px;
      font-weight: bold;
      background: #f5f5f5;
      border-top: 1px solid #ccc;
      margin-top: 20px;
      margin-bottom: 10px;
    }

    .store-description img {
      width: 100%;
      margin-top: 20px;
      border-radius: 10px;
    }

    .info-table {
      width: 100%;
      border-collapse: collapse;
    }

    .info-table td {
      padding: 8px 5px;
      border-bottom: 1px solid #eee;
    }

    .info-table td:first-child {
      font-weight: bold;
      width: 40%;
      color: #444;
    }

    nav.bottom-nav {
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      border-top: 1px solid #eee;
      background-color: white;
      flex-shrink: 0;
    }

    .bottom-nav a {
      color: #555;
      font-size: 1.5em;
      text-decoration: none;
      padding: 10px 15px;
      transition: color 0.2s;
      display: inline-flex;
      align-items: center;
      justify-content: center;
    }

    .bottom-nav a:hover,
    .bottom-nav a.active {
      color: #007bff;
    }
  </style>
</head>

<body>
  <div class="app-container">
    <div class="main-content">
      <div class="header">
        <a href="javascript:history.back();" class="back-button"><i class="fas fa-arrow-left"></i></a>
      </div>

      <div class="store-info">
        <h1>
          <?= htmlspecialchars($restaurant['name']) ?>
        </h1>
        <p><strong>주소:</strong>
          <?= htmlspecialchars($restaurant['location']) ?>
        </p>
        <p><strong>운영시간:</strong>
          <?= htmlspecialchars($restaurant['opening_hours']) ?>
        </p>
        <p><strong>전화번호:</strong>
          <?= htmlspecialchars($restaurant['phone']) ?>
        </p>
      </div>

      <div class="store-description">
        <div class="section-title">가게 소개</div>
        <p>
          <?= nl2br(htmlspecialchars($info['description'])) ?>
        </p>
        <img src="<?= htmlspecialchars($restaurant['image_url']) ?>" alt="가게 이미지">
      </div>

      <div class="certifications">
        <div class="section-title">가게 인증내역</div>
        <table class="info-table">
          <tr>
            <td>위생관리 인증</td>
            <td>
              <?= htmlspecialchars($info['hygiene_certification']) ?>
            </td>
          </tr>
          <tr>
            <td>소독 인증</td>
            <td>
              <?= htmlspecialchars($info['disinfection_certification']) ?>
            </td>
          </tr>
          <tr>
            <td>원산지 표시</td>
            <td>
              <?= htmlspecialchars($info['origin_certification']) ?>
            </td>
          </tr>
          <tr>
            <td>수상 경력</td>
            <td>
              <?= htmlspecialchars($info['awards']) ?>
            </td>
          </tr>
        </table>
      </div>

      <div class="statistics">
        <div class="section-title">가게 통계</div>
        <table class="info-table">
          <tr>
            <td>리뷰 수</td>
            <td>
              <?= $review_data['review_count'] ?>개
            </td>
          </tr>
          <tr>
            <td>찜 수</td>
            <td>
              <?= $dibs_data['dibs_count'] ?>회
            </td>
          </tr>
          <tr>
            <td>별점 평균</td>
            <td>
              <?= is_null($review_data['avg_rating']) ? '-' : $review_data['avg_rating'] ?>/5.0
            </td>
          </tr>
        </table>
      </div>

      <div class="business-info">
        <div class="section-title">사업자 정보</div>
        <table class="info-table">
          <tr>
            <td>대표자명</td>
            <td>
              <?= htmlspecialchars($info['representative_name']) ?>
            </td>
          </tr>
          <tr>
            <td>사업자등록번호</td>
            <td>
              <?= htmlspecialchars($info['business_number']) ?>
            </td>
          </tr>
          <tr>
            <td>사업자 주소</td>
            <td>
              <?= htmlspecialchars($info['business_address']) ?>
            </td>
          </tr>
        </table>
      </div>


    </div>

    <nav class="bottom-nav">
      <a href="../../main.php"><i class="fas fa-home"></i></a>
      <a href="../user/dibs.php"><i class="fas fa-heart"></i></a>
      <a href="../order/orderlist.php" class="active"><i class="fas fa-receipt"></i></a>
      <a href="../../auth/redirect-mypage.php"><i class="fas fa-user"></i></a>
    </nav>
  </div>
</body>

</html>