<?php
session_start();
require_once "../../includes/db_connect.php";

$report_message = "";
$page_title = "신고하기";
$form_action_url_params = "";

$review_id = isset($_GET['review_id']) ? filter_var($_GET['review_id'], FILTER_VALIDATE_INT) : null;
$reported_user_id = isset($_GET['reported_user_id']) ? filter_var($_GET['reported_user_id'], FILTER_VALIDATE_INT) : null;

$return_url = 'javascript:history.back();';
if (isset($_GET['return_url'])) {
    $return_url_from_get = htmlspecialchars_decode(urldecode($_GET['return_url']));
    if (preg_match('/^(\/|http:\/\/'.preg_quote($_SERVER['HTTP_HOST']).'|https:\/\/'.preg_quote($_SERVER['HTTP_HOST']).')/i', $return_url_from_get)) {
        $return_url = $return_url_from_get;
    }
} elseif (isset($_POST['return_url'])) {
    $return_url_from_post = htmlspecialchars_decode(urldecode($_POST['return_url']));
     if (preg_match('/^(\/|http:\/\/'.preg_quote($_SERVER['HTTP_HOST']).'|https:\/\/'.preg_quote($_SERVER['HTTP_HOST']).')/i', $return_url_from_post)) {
        $return_url = $return_url_from_post;
    }
} elseif (isset($_SERVER['HTTP_REFERER'])) {
    $return_url = $_SERVER['HTTP_REFERER'];
}
$previous_url = htmlspecialchars($return_url);

$reported_username = "알 수 없는 사용자";

if (!$review_id || !$reported_user_id || $review_id <= 0 || $reported_user_id <= 0) {
    $report_message = "잘못된 접근입니다. 신고할 리뷰 또는 사용자를 특정할 수 없습니다.";
} else {
    $form_action_url_params = '?review_id=' . htmlspecialchars($review_id) . '&reported_user_id=' . htmlspecialchars($reported_user_id);
    if (isset($_GET['return_url'])) {
        $form_action_url_params .= '&return_url=' . urlencode($return_url); // GET으로 받은 return_url을 계속 전달
    } elseif (isset($_POST['return_url'])) { // POST로 받은 return_url도 계속 전달
        $form_action_url_params .= '&return_url=' . urlencode($return_url);
    }


    $sql_user = "SELECT username FROM Users WHERE user_id = ?";
    if ($stmt_user = $conn->prepare($sql_user)) {
        $stmt_user->bind_param("i", $reported_user_id);
        $stmt_user->execute();
        $result_user = $stmt_user->get_result();
        if ($row_user = $result_user->fetch_assoc()) {
            $reported_username = htmlspecialchars($row_user['username']);
            $page_title = "리뷰 신고";
        } else {
            $report_message = "신고 대상 사용자 정보를 찾을 수 없습니다.";
        }
        $stmt_user->close();
    } else {
        error_log("Declaration.php: 사용자 정보 SQL 준비 실패: " . $conn->error);
        $report_message = "사용자 정보를 가져오는 중 오류가 발생했습니다.";
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($report_message)) {
        if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
            $report_message = "유효하지 않은 요청입니다. 페이지를 새로고침 후 다시 시도해주세요.";
        } else {
            $reason = isset($_POST['reason']) ? trim($_POST['reason']) : '';
            $hidden_review_id = isset($_POST['review_id']) ? (int)$_POST['review_id'] : 0;
            $hidden_reported_user_id = isset($_POST['reported_user_id']) ? (int)$_POST['reported_user_id'] : 0;

            if ($hidden_review_id !== $review_id || $hidden_reported_user_id !== $reported_user_id) {
                $report_message = "요청 정보가 일치하지 않습니다.";
            } elseif (empty($reason)) {
                $report_message = "신고 사유를 입력해주세요.";
            } else {
                $reporter_user_id = (int)$_SESSION['user_id']; 
                $reason_for_db = htmlspecialchars($reason);

                // 동일 사용자가 동일 리뷰에 대해 이미 'pending' 상태로 신고했는지 확인
                $sql_check_duplicate = "SELECT declaration_id FROM Declarations WHERE review_id = ? AND reporter_user_id = ? AND status = 'pending'";
                if ($stmt_check_dup = $conn->prepare($sql_check_duplicate)) {
                    $stmt_check_dup->bind_param("ii", $review_id, $reporter_user_id);
                    $stmt_check_dup->execute();
                    $result_dup = $stmt_check_dup->get_result();
                    if ($result_dup->num_rows > 0) {
                        $report_message = "이미 해당 리뷰에 대해 처리 대기 중인 신고가 있습니다.";
                    }
                    $stmt_check_dup->close();
                } else {
                    error_log("Declaration.php: 중복 신고 확인 SQL 준비 실패: " . $conn->error);
                    $report_message = "신고 처리 중 내부 오류가 발생했습니다. (코드: D01)";
                }

                if (empty($report_message)) { // 중복 신고가 아닐 경우 또는 중복 확인 실패 시 
                    $sql_insert_report = "INSERT INTO Declarations (review_id, reporter_user_id, reported_user_id, reason, created_at, status) 
                                          VALUES (?, ?, ?, ?, NOW(), 'pending')";
                    if ($stmt_insert = $conn->prepare($sql_insert_report)) {
                        $stmt_insert->bind_param("iiis", $review_id, $reporter_user_id, $reported_user_id, $reason_for_db);
                        if ($stmt_insert->execute()) {
                            $report_message = htmlspecialchars($reported_username) . "님에 대한 리뷰 신고가 정상적으로 접수되었습니다.";
                            if(isset($_SESSION['csrf_token'])) unset($_SESSION['csrf_token']);
                        } else {
                            $report_message = "신고 처리 중 오류가 발생했습니다. 잠시 후 다시 시도해주세요. (코드: D02)";
                            error_log("Declaration.php: 신고 INSERT 실패: " . $stmt_insert->error . " - Params: review_id=$review_id, reporter=$reporter_user_id, reported=$reported_user_id");
                        }
                        $stmt_insert->close();
                    } else {
                        $report_message = "신고 처리 준비 중 오류가 발생했습니다. (코드: D03)";
                        error_log("Declaration.php: 신고 INSERT SQL 준비 실패: " . $conn->error);
                    }
                }
            }
        }
    }
}

// CSRF 토큰 생성 또는 유지
$csrf_token = "";
if (session_status() == PHP_SESSION_ACTIVE) {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    $csrf_token = $_SESSION['csrf_token'];
}

?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <style>
        body { 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; 
            background-color: #f8f9fa; 
            display: flex; 
            justify-content: center; 
            align-items: center;
            min-height: 100vh; 
            margin: 0; 
            padding: 20px;
            box-sizing: border-box;
        }
        .container { 
            background-color: #fff; 
            padding: 25px 30px; 
            border-radius: 8px; 
            box-shadow: 0 4px 8px rgba(0,0,0,0.1); 
            width: 450px; 
            max-width: 100%;
        }
        h2 { text-align: center; margin-top: 0; margin-bottom: 25px; color: #343a40; font-size: 1.5em; }
        .info-box { background-color: #e9ecef; padding: 10px 15px; border-radius: 4px; margin-bottom: 20px; font-size: 0.95em; color: #495057; }
        .info-box p { margin: 5px 0; }
        .info-box strong { color: #007bff; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; color: #495057; font-weight: 500; font-size:0.9em; }
        textarea { width: 100%; padding: 12px; border: 1px solid #ced4da; border-radius: 4px; box-sizing: border-box; font-size: 1em; resize: vertical; min-height: 100px; }
        textarea:focus { border-color: #80bdff; outline: 0; box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25); }
        .button-group { display: flex; justify-content: flex-end; gap: 10px; margin-top: 25px; }
        button, a.button { padding: 10px 18px; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; color: #fff; font-size: 0.95em; transition: background-color 0.2s ease-in-out; }
        button[type="submit"] { background-color: #dc3545; }
        button[type="submit"]:hover { background-color: #c82333; }
        a.button { background-color: #6c757d; display: inline-block; text-align:center; }
        a.button:hover { background-color: #5a6268; }
        .message-display { text-align: center; margin-top: 25px; padding: 15px; border-radius: 4px; font-weight: 500; word-break: keep-all; }
        .message-display.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;}
        .message-display.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>
    <div class="container">
        <h2><?php echo htmlspecialchars($page_title); ?></h2>

        <?php 
        $show_form = true;
        if (!empty($report_message)) {
            if (strpos($report_message, '접수되었습니다') !== false || 
                strpos($report_message, "잘못된 접근") !== false ||
                strpos($report_message, "사용자 정보를 찾을 수 없습니다") !== false ||
                strpos($report_message, "유효하지 않은 요청입니다") !== false && strpos($report_message, "페이지를 새로고침") === false 
            ) {
                $show_form = false;
            }
        }
        if (!$review_id || !$reported_user_id) { // 필수 GET 파라미터 없으면 폼 안보여줌
            $show_form = false;
            if(empty($report_message)) $report_message = "잘못된 접근입니다. 필수 정보가 누락되었습니다.";
        }
        ?>

        <?php if (!empty($report_message)): ?>
            <div class="message-display <?php echo (strpos($report_message, '접수되었습니다') !== false && strpos($report_message, '오류') === false && strpos($report_message, '실패') === false) ? 'success' : 'error'; ?>">
                <?php echo $report_message; ?>
            </div>
        <?php endif; ?>

        <?php if ($show_form): ?>
            <div class="info-box">
                <p>신고 대상: <strong><?php echo $reported_username; ?></strong></p>
                </div>

            <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']) . $form_action_url_params; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                <input type="hidden" name="review_id" value="<?php echo htmlspecialchars($review_id); ?>">
                <input type="hidden" name="reported_user_id" value="<?php echo htmlspecialchars($reported_user_id); ?>">
                <input type="hidden" name="return_url" value="<?php echo htmlspecialchars($return_url); ?>">
                
                <div class="form-group">
                    <label for="reason">신고 사유:</label>
                    <textarea id="reason" name="reason" rows="6" placeholder="신고 사유를 명확하고 구체적으로 작성해주세요. (예: 부적절한 내용, 스팸, 욕설 등)" required></textarea>
                </div>
                <div class="button-group">
                    <a href="<?php echo $previous_url; ?>" class="button">취소</a>
                    <button type="submit">신고 제출</button>
                </div>
            </form>
        <?php elseif (empty($report_message) && (!$review_id || !$reported_user_id)): ?>
            <?php endif; ?>

        <?php 
        if (!$show_form && !empty($report_message)): ?>
            <div class="button-group" style="justify-content: center; margin-top: 15px;">
                <a href="<?php echo $previous_url; ?>" class="button">돌아가기</a>
            </div>
        <?php endif; ?>
    </div>
    <?php
    if (isset($conn) && $conn instanceof mysqli) {
        $conn->close();
    }
    ?>
</body>
</html>