<?php
require_once "../../includes/islogin.php"; // 로그인 체크
require_once "../../includes/db_connect.php";  // DB 연결 

$user_id = $_SESSION['user_id']; // 로그인한 사용자 ID
$restaurant_id = $_GET['restaurant_id'] ?? null;

if (!$restaurant_id) {
    echo "잘못된 접근입니다. 가게 ID가 필요합니다.";
    exit;
}

// 가게 정보 조회
$stmt = $conn->prepare("SELECT name, location, opening_hours, phone FROM Restaurants WHERE restaurant_id = ?");
$stmt->bind_param("i", $restaurant_id);
$stmt->execute();
$result = $stmt->get_result();
$restaurant = $result->fetch_assoc();
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $date = $_POST['date'];
    $time = $_POST['time'];
    $people = $_POST['people'];

    $reservation_datetime = $date . ' ' . $time . ':00';

    $stmt = $conn->prepare("INSERT INTO Reservations (user_id, reservation_time, food_id, status) VALUES (?, ?, NULL, 'pending')");
    $stmt->bind_param("is", $user_id, $reservation_datetime);

    $stmt->execute();
    $stmt->close();

    // 결제 페이지로 이동
    header("Location: payment-confirm.html");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <link rel="stylesheet" href="../../assets/css/reservationInfo.css" />
  <title>예약 정보 입력</title>
</head>
<body>
  <div class="container">
    <h2>예약 정보 입력</h2>

    <div class="info-box">
      <p>가게명 : <?= htmlspecialchars($restaurant['name']) ?></p>
      <p>위치 : <?= htmlspecialchars($restaurant['location']) ?></p>
      <p>운영시간 : <?= htmlspecialchars($restaurant['opening_hours']) ?></p>
      <p>전화번호 : <?= htmlspecialchars($restaurant['phone']) ?></p>
    </div>

    <form method="POST">
    <div class="select-group">
      <label for="date">예약 날짜</label>
      <select name="date" id="date">
        <?php
        $year = date('Y');
        $month = date('m');
        $today_day = (int)date('d');
        $days_in_month = date('t');

        for ($d = 1; $d <= $days_in_month; $d++) {
            $date_str = sprintf('%04d-%02d-%02d', $year, $month, $d);
            $disabled = ($d < $today_day) ? 'disabled' : '';
            echo "<option value=\"$date_str\" $disabled>$date_str</option>";
        }
        ?>
      </select>
    </div>


      <div class="select-group">
        <label for="time">예약 시간</label>
        <select name="time" id="time">
          <?php
          for ($h = 9; $h <= 17; $h++) {
              foreach ([0, 30] as $m) {
                  $time = sprintf('%02d:%02d', $h, $m);
                  echo "<option value=\"$time\">$time</option>";
              }
          }
          ?>
        </select>
      </div>

      <div class="select-group">
        <label for="people">예약 인원</label>
        <select name="people" id="people">
          <?php for ($i = 1; $i <= 10; $i++): ?>
            <option value="<?php echo $i; ?>"><?php echo $i; ?>명</option>
          <?php endfor; ?>
        </select>
      </div>

      <h4>주문 메뉴</h4>
      <div class="menu-list">
        <div class="menu-box">
          <div class="menu-row">
            <span>순두부찌개</span><span>1개</span>
          </div>
          <div class="menu-row">
            <span>제육볶음</span><span>1개</span>
          </div>
        </div>
      </div>

      <h4>예약 시 유의사항</h4>
      <div class="notice">
        <p>인당 1인 1메뉴는 필수이며, 최소 주문 금액은 x,xxx원 입니다.</p>
        <p>또한 ~~~ 이를 지키지 않을 시 ~~</p>
      </div>

      <div class="checkbox-group">
        <label class="checkbox-item">
          <span>개인정보 수집 및 활용 동의</span>
          <input type="checkbox" name="agree" required />
        </label>
        <label class="checkbox-item">
          <span>푸시 알림 허용 여부</span>
          <input type="checkbox" name="push" />
        </label>
      </div>

      <button class="btn" type="submit">결제</button>
    </form>
  </div>
</body>
</html>
