<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 현재 실행 중인 스크립트 경로 가져오기 
$current_path = $_SERVER['SCRIPT_NAME'];

// Capstone 이후의 경로만 추출 
$relative_from_capstone = explode('Capstone/', $current_path)[1] ?? '';

// 얼마나 깊이 들어가 있는지 계산
$depth = substr_count($relative_from_capstone, '/');

// 상대경로 생성
$relativePath = str_repeat('../', $depth) . 'auth/login.php';

// 로그인 안 된 경우 로그인 페이지로 이동
if (!isset($_SESSION['user_id'])) {
    $redirect = urlencode($_SERVER['REQUEST_URI']);
    header("Location: {$relativePath}?redirect=$redirect");
    exit;
}

// 세션 만료 시 처리
if (isset($_SESSION['expire_time']) && time() > $_SESSION['expire_time']) {
    session_unset();
    session_destroy();
    $redirect = urlencode($_SERVER['REQUEST_URI']);
    header("Location: {$relativePath}?timeout=1&redirect=$redirect");
    exit;
}
?>