<?php
require_once "../includes/db_connect.php";
require_once "../includes/islogin.php";

$response = ['success' => false, 'message' => '', 'isFavorited' => false];

// 1. 로그인 확인 및 사용자 ID 가져오기 (Users 테이블의 user_id)
if (!isset($_SESSION['user_id'])) {
    $response['message'] = '로그인이 필요합니다.';
    exit;
}
$userId = $_SESSION['user_id'];

// 2. 식당 ID 받아오기 (Restaurants 테이블의 restaurant_id)
if (!isset($_POST['restaurant_id']) || !filter_var($_POST['restaurant_id'], FILTER_VALIDATE_INT)) {
    $response['message'] = '잘못된 식당 정보입니다.';
    exit;
}
$restaurantId = (int)$_POST['restaurant_id'];

// 3. DB 연결 확인
if ($conn->connect_error) {
    $response['message'] = '데이터베이스 연결 오류: ' . $conn->connect_error;
    exit;
}

// 4. 현재 찜 상태 확인 (User_favorites 테이블 사용)
$stmt_check = $conn->prepare("SELECT COUNT(*) FROM User_favorites WHERE user_id = ? AND restaurant_id = ?");
if (!$stmt_check) {
    $response['message'] = 'DB 준비 오류 (check): ' . $conn->error;
    exit;
}
$stmt_check->bind_param("ii", $userId, $restaurantId);
$stmt_check->execute();
$stmt_check->bind_result($count);
$stmt_check->fetch();
$stmt_check->close();

$isCurrentlyFavorited = ($count > 0);

// 5. 찜 상태 토글 (User_favorites 테이블에 추가 또는 삭제)
try {
    if ($isCurrentlyFavorited) {
        $stmt_delete = $conn->prepare("DELETE FROM User_favorites WHERE user_id = ? AND restaurant_id = ?");
        if (!$stmt_delete) throw new Exception('DB 준비 오류 (delete): ' . $conn->error);
        $stmt_delete->bind_param("ii", $userId, $restaurantId);
        $stmt_delete->execute();

        if ($stmt_delete->affected_rows > 0) {
            $response['success'] = true;
            $response['isFavorited'] = false;
            $response['message'] = '찜 목록에서 제거되었습니다.';
        } else {
            throw new Exception('찜 해제 실패.');
        }
        $stmt_delete->close();
    } else {
        $stmt_insert = $conn->prepare("INSERT INTO User_favorites (user_id, restaurant_id) VALUES (?, ?)");
        if (!$stmt_insert) throw new Exception('DB 준비 오류 (insert): ' . $conn->error);
        $stmt_insert->bind_param("ii", $userId, $restaurantId);
        $stmt_insert->execute();

        if ($stmt_insert->affected_rows > 0) {
            $response['success'] = true;
            $response['isFavorited'] = true;
            $response['message'] = '찜 목록에 추가되었습니다.';
        } else {
            throw new Exception('찜 추가 실패.');
        }
        $stmt_insert->close();
    }
} catch (mysqli_sql_exception $e) {
    $response['message'] = '데이터베이스 오류: ' . $e->getMessage();
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

// 6. DB 연결 종료
$conn->close();

// 7. 최종 응답 전송
header('Content-Type: application/json');
echo json_encode($response);
?>