<?php
require_once '../includes/db_connect.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $username = trim($_POST['name']);           // 이름
    $email = trim($_POST['email']);
    $student_id = trim($_POST['student_id']);   // 관리자 계정이면 NULL로 처리
    $is_admin = empty($student_id) ? 1 : 0;     // 학번 없으면 관리자
    $created_at = date("Y-m-d H:i:s");


    // $check_sql = "SELECT * FROM users WHERE username = ?";
    // $stmt = $conn->prepare($check_sql);
    // $stmt->bind_param("s", $userid);
    // $stmt->execute();
    

    // $stmt->store_result();  // 필요한 메모리 확보
    // if ($stmt->num_rows > 0) {
    //     echo "이미 존재하는 아이디입니다.";
    //     exit;
    // }

    // 회원 정보 저장
    $insert_sql = "INSERT INTO Users (student_id, username, email, is_admin, created_at, password)
    VALUES (?, ?, ?, ?, ?, ?)";
    
    // 쿼리 실행 준비
    $stmt = $conn->prepare($insert_sql);
    // 올바르게 순서 맞춘 코드:
    $stmt->bind_param("sssiss", $student_id, $username, $email, $is_admin, $created_at, $password);


    if ($stmt->execute()) {
        echo "회원가입 성공!";
    } else {
        echo "오류 발생: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
