<?php
session_start();
require_once '../includes/db_connect.php'; // DB 연결
require '../vendor/autoload.php'; // PHPMailer

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $student_id = trim($_POST['student_id']);

    // Users 테이블에서 사용자 조회
    $stmt = $conn->prepare("SELECT user_id FROM Users WHERE email = ? AND student_id = ?");
    if (!$stmt) {
        $_SESSION['error'] = '쿼리 준비 중 오류가 발생했습니다.';
        header('Location: ../pages/user/forgot-password.php');
        exit;
    }

    $stmt->bind_param("ss", $email, $student_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows === 1) {
        $user = $result->fetch_assoc();
        $user_id = $user['user_id'];

        // 인증코드 생성 및 해시
        $code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $code_hash = password_hash($code, PASSWORD_DEFAULT);
        $expires_at = date('Y-m-d H:i:s', strtotime('+30 minutes'));

        // 기존 코드 제거
        $del = $conn->prepare("DELETE FROM Password_reset_codes WHERE user_id = ? AND used = 0");
        $del->bind_param("i", $user_id);
        $del->execute();

        // 새로운 인증코드 저장
        $insert = $conn->prepare("INSERT INTO Password_reset_codes (user_id, code, expires_at) VALUES (?, ?, ?)");
        $insert->bind_param("iss", $user_id, $code_hash, $expires_at);
        $insert->execute();

        // 이메일 발송
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'kyc080418@gmail.com'; // 본인 이메일
            $mail->Password = 'atbdmelxcbefrxcb';    // 앱 비밀번호
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            $mail->setFrom('kyc080418@gmail.com', 'M-Order 관리자');
            $mail->addAddress($email);
            $mail->isHTML(true);
            $mail->Subject = '비밀번호 재설정 인증코드';
            $mail->Body = "안녕하세요,<br>아래 인증코드를 입력하여 비밀번호 재설정을 진행하세요.<br><h2>{$code}</h2><br>이 코드는 30분간 유효합니다.";

            $mail->send();

            $_SESSION['message'] = '인증코드가 이메일로 발송되었습니다.';
            $_SESSION['reset_email'] = $email; // 이후 인증 코드 확인 단계에서 사용
            header('Location: enter-code.php?user_id=' . $user_id);
            exit;

        } catch (Exception $e) {
            $_SESSION['error'] = '이메일 전송 실패: ' . $mail->ErrorInfo;
            header('Location: ../pages/user/forgot-password.php');
            exit;
        }

    } else {
        $_SESSION['error'] = '해당 이메일 또는 학번을 찾을 수 없습니다.';
        header('Location: ../pages/user/forgot-password.php');
        exit;
    }
} else {
    header('Location: ../pages/user/forgot-password.php');
    exit;
}
