<?php
session_start();
require '../includes/db_connect.php';

$email = $_POST['email'] ?? '';
$input_password = $_POST['password'] ?? '';

// $redirect 값을 미리 준비 (login.php로 돌아갈 때도 전달하기 위함)
$redirect_param_for_login_page = '';
if (isset($_POST['redirect']) && !empty(trim($_POST['redirect']))) {
    $redirect_param_for_login_page = '?redirect=' . urlencode(trim($_POST['redirect']));
} else if (isset($_GET['redirect_initial']) && !empty(trim($_GET['redirect_initial']))) { 
    $redirect_param_for_login_page = '?redirect=' . urlencode('../main');
} else {
    // 기본 redirect 파라미터가 없다면, login.php로만 이동
}


$login_page_url = 'login.php';

// 이메일이나 비밀번호가 비어있는 경우
if (empty($email)) {
    $_SESSION['login_error_message'] = '이메일을 입력해주세요.'; // 세션에 오류 메시지 저장
    header("Location: " . $login_page_url . $redirect_param_for_login_page);
    exit;
}
if (empty($input_password)) {
    $_SESSION['login_error_message'] = '비밀번호를 입력해주세요.';
    header("Location: " . $login_page_url . $redirect_param_for_login_page);
    exit;
}

$sql = "SELECT user_id, username, password, is_admin FROM Users WHERE email = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    error_log("Login Error - SQL Prepare Failed (Users select): " . $conn->error);
    $_SESSION['login_error_message'] = '로그인 처리 중 시스템 오류가 발생했습니다. (DBP1)';
    header("Location: " . $login_page_url . $redirect_param_for_login_page);
    exit;
}

$stmt->bind_param("s", $email);
if(!$stmt->execute()) {
    error_log("Login Error - SQL Execute Failed (Users select): " . $stmt->error);
    $_SESSION['login_error_message'] = '로그인 처리 중 시스템 오류가 발생했습니다. (DBE1)';
    $stmt->close();
    $conn->close();
    header("Location: " . $login_page_url . $redirect_param_for_login_page);
    exit;
}
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();

    if (password_verify($input_password, $user['password'])) {
    $_SESSION['user_id'] = $user['user_id'];
    $_SESSION['username'] = $user['username'];
    $_SESSION['is_admin'] = $user['is_admin'];
    $user_id = $user['user_id'];


        $redirect_url = isset($_POST['redirect']) && !empty($_POST['redirect']) ? $_POST['redirect'] : '../main.php';

        echo "<script>
                alert('로그인 성공!');
                location.href='{$redirect_url}?from_login=1&user_id={$user_id}';
              </script>";
        exit;
    } else {

        echo "<script>
                alert('비밀번호가 올바르지 않습니다.');
                history.back();
              </script>";
        exit;
    }
} else {
    echo "<script>
            alert('이메일이 존재하지 않습니다.');
            history.back();
          </script>";
    exit;
}
?>