<?php
session_start();
// 현재 이동할 페이지가 있으면 받아둠 (없으면 기본값 main.php)
$redirect_default_path = '../main.php'; 
$redirect = isset($_GET['redirect']) && !empty(trim($_GET['redirect'])) ? trim($_GET['redirect']) : $redirect_default_path;
?>

<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>M-Order 로그인</title>
  <link rel="stylesheet" href="../assets/css/style_main.css" />
  <style>
    body {
      background-color: #f4f4f4;
      margin: 0;
      font-family: sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    .login-wrapper {
      width: 100%;
      max-width: 400px;
      background-color: white;
      padding: 30px 20px;
      box-sizing: border-box;
      border: 1px solid #e0e0e0;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
      border-radius: 10px;
    }

    .login-wrapper h2 {
      text-align: center;
      margin-bottom: 30px;
      font-size: 1.5em;
    }

    .login-form label {
      display: block;
      margin-bottom: 6px;
      font-size: 0.95em;
      color: #333;
    }

    .login-form input[type="email"],
    .login-form input[type="password"] {
      width: 100%;
      padding: 12px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 1em;
      box-sizing: border-box;
    }

    .login-form input[type="checkbox"] {
      margin-right: 8px;
    }

    .login-form button, button {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      font-size: 1em;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: background-color 0.2s ease-in-out;
    }

    .login-form button:hover {
      background-color: #0056b3;
    }

    .forgot-password {
      text-align: right;
      margin-top: -15px;
      margin-bottom: 15px;
    }

    .forgot-password a {
      font-size: 0.9em;
      color: #007bff;
      text-decoration: none;
    }

    .forgot-password a:hover {
      text-decoration: underline;
    }

    .public-check {
      font-size: 0.9em;
      margin-bottom: 20px;
      color: #333;
    }

    @media (max-width: 400px) {
      .login-wrapper {
        padding: 20px 15px;
      }
    }
  </style>
</head>
<body>
  <div class="login-wrapper">
    <h2>M-Order 로그인</h2>

    <?php if (isset($_GET['timeout'])): ?>
      <script>alert("세션이 만료되어 자동 로그아웃되었습니다.");</script>
    <?php endif; ?>

    <form class="login-form" action="login_process.php" method="POST">
      <input type="hidden" name="redirect" value="<?php echo htmlspecialchars($redirect); ?>">

      <label for="email">이메일</label>
      <input type="email" id="email" name="email" required />

      <label for="password">비밀번호</label>
      <input type="password" id="password" name="password" required />

      <div class="forgot-password">
        <a href="forgot-password.php">비밀번호를 잊어버리셨나요?</a>
      </div>

      <div class="public-check">
        <label><input type="checkbox" name="public_place" value="1"> 공공장소에서 로그인 중입니다</label>
      </div>

      <button type="submit">로그인</button>
    </form>
    <button onclick="location.href='signup.php'" style="margin-top: 10px;">회원가입</button>
  </div>
</body>
</html>
