<?php
session_start();
$user_id = $_GET['user_id'] ?? null;
if (!$user_id) {
    die("잘못된 접근입니다.");
}
?>
<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8" />
  <title>인증코드 입력</title>
  <style>
    body {
      background-color: #f8f9fa;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      margin: 0;
      padding: 0;
    }

    .container {
              height: 100%;
              max-width: 400px;
              margin: 0 auto;
              display: flex;
              flex-direction: column;
              background-color: white;
              border: 1px solid #e0e0e0;
              box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            }

    h2 {
      text-align: center;
      margin-bottom: 30px;
      font-size: 1.5em;
      color: #333;
    }

    label {
      display: block;
      margin-bottom: 8px;
      font-weight: bold;
      font-size: 0.95em;
      color: #333;
    }

    input {
      width: 100%;
      padding: 12px;
      margin-bottom: 20px;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 1em;
      transition: border-color 0.3s, box-shadow 0.3s;
    }

    input:focus {
      border-color: #007bff;
      box-shadow: 0 0 5px rgba(0, 123, 255, 0.4);
      outline: none;
    }

    button {
      width: 100%;
      padding: 12px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-size: 1em;
      cursor: pointer;
      transition: background-color 0.2s ease;
    }

    button:hover {
      background-color: #0056b3;
    }

    p.error {
      color: red;
      text-align: center;
      margin-bottom: 20px;
    }

    @media (max-width: 480px) {
      .container {
        margin: 40px 16px;
        padding: 30px 16px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>이메일로 전송된 인증코드를 입력하세요</h2>
    <?php if (isset($_SESSION['error'])): ?>
      <p class="error"><?= $_SESSION['error']; unset($_SESSION['error']); ?></p>
    <?php endif; ?>
    <form action="/Capstone/pages/user/verify-code.php" method="POST">
      <input type="hidden" name="user_id" value="<?= htmlspecialchars($user_id) ?>">
      <label for="code">인증코드</label>
      <input type="text" id="code" name="code" required />
      <button type="submit">확인</button>
    </form>
  </div>
</body>
</html>
