<?php
require '../includes/islogin.php';
require '../includes/db_connect.php';
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$food_id = $_POST['food_id'] ?? null;

if (!$user_id || !$food_id) {
  echo json_encode(['success' => false, 'message' => '잘못된 요청']);
  exit;
}

$sql = "DELETE FROM Cart WHERE user_id = ? AND food_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $food_id);

if ($stmt->execute()) {
  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false, 'message' => 'DB 오류']);
}
