<?php
require_once('../includes/db_connect.php');
require_once('../includes/islogin.php');

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 선택된 사유 받아오기
    $reasons = isset($_POST['reasons']) ? $_POST['reasons'] : [];
    $etc_reason = isset($_POST['etc_reason']) ? trim($_POST['etc_reason']) : '';

    // 사유 합치기 (예: "자주 이용하지 않음, 기타: ~~~")
    $reason_text = implode(', ', $reasons);
    if ($etc_reason !== '') {
        $reason_text .= ($reason_text ? ', ' : '') . "기타: " . $etc_reason;
    }

    // Users 테이블에서 회원 삭제
    $stmt = $conn->prepare("DELETE FROM Users WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();

    // 로그아웃 처리 및 메시지
    session_destroy();
    echo "<script>alert('그동안 M오더를 이용해주셔서 감사합니다.'); location.href = '../main.php';</script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8" />
    <title>회원 탈퇴</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            font-family: sans-serif;
            display: flex;
            justify-content: center;
        }

        .container {
            width: 100%;
            max-width: 420px;
            min-height: 100vh;
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            padding: 30px 20px 60px;
            box-sizing: border-box;
        }

        h2 {
            margin: 0 0 20px;
            font-size: 24px;
            color: #d32f2f;
            text-align: center;
        }

        form {
            flex-grow: 1;
        }

        label {
            display: block;
            margin-bottom: 15px;
            font-size: 16px;
            cursor: pointer;
        }

        input[type="checkbox"] {
            margin-right: 10px;
        }

        textarea {
            width: 100%;
            min-height: 80px;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 6px;
            resize: vertical;
            margin-bottom: 20px;
            box-sizing: border-box;
        }

        button {
            width: 100%;
            padding: 14px 0;
            font-size: 18px;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            margin-bottom: 10px;
            box-sizing: border-box;
        }

        button.delete-btn {
            background-color: #d32f2f;
            color: white;
        }

        button.delete-btn:hover {
            background-color: #b22222;
        }

        button.cancel-btn {
            background-color: #888;
            color: white;
        }

        button.cancel-btn:hover {
            background-color: #555;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>탈퇴를 원하시는 사유를 알려주세요.</h2>
    <form method="post" action="">
        <label><input type="checkbox" name="reasons[]" value="자주 이용하지 않음"> 자주 이용하지 않음</label>
        <label><input type="checkbox" name="reasons[]" value="주문 매장 부족"> 주문 매장 부족</label>
        <label><input type="checkbox" name="reasons[]" value="회원 및 할인 혜택 부족"> 회원 및 할인 혜택 부족</label>
        <label><input type="checkbox" name="reasons[]" value="개인정보 등 보안 우려"> 개인정보 등 보안 우려</label>
        <label><input type="checkbox" name="reasons[]" value="기타"> 기타</label>
        <textarea name="etc_reason" placeholder="기타 사유가 있다면 적어주세요."></textarea>

        <button type="submit" class="delete-btn">탈퇴하기</button>
        <button type="button" class="cancel-btn" onclick="history.back();">계속 이용하기</button>
    </form>
</div>
</body>
</html>
