<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8" />
    <title>회원 탈퇴 확인</title>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background: #f9f9f9;
            margin: 0; padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
              height: 100%;
              max-width: 400px;
              margin: 0 auto;
              display: flex;
              flex-direction: column;
              background-color: white;
              border: 1px solid #e0e0e0;
              box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            }
        h1 {
            margin-bottom: 10px;
            font-size: 22px;
            color: #d9534f;
        }
        .small-text {
            font-size: 13px;
            color: #777;
            margin-bottom: 20px;
        }
        .warning-text {
            font-size: 15px;
            margin-bottom: 25px;
            text-align: left;
            color: #555;
        }
        .warning-text ul {
            margin: 10px 0 0 20px;
            padding: 0;
            color: #d9534f;
            list-style-type: disc;
        }
        button {
            border: none;
            padding: 12px 25px;
            font-size: 16px;
            border-radius: 6px;
            cursor: pointer;
            margin: 0 10px;
            transition: background-color 0.3s;
        }
        .btn-delete {
            background-color: #d9534f;
            color: white;
        }
        .btn-delete:hover {
            background-color: #c9302c;
        }
        .btn-cancel {
            background-color: #6c757d;
            color: white;
        }
        .btn-cancel:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>안산대 M오더를 탈퇴하시겠어요?</h1>
    <div class="small-text">
        지금 탈퇴 하시면, 회원님에게만 제공되는<br />
        특별한 혜택을 더 이상 만나보실 수 없어요.
    </div>
    <div class="warning-text">
        <strong>탈퇴 하시기 전 다시 한번 확인해 주세요!</strong>
        <ul>
            <li>예약 및 결제 내역 조회 불가</li>
            <li>할인 쿠폰 및 이벤트 참여 기록 소멸</li>
            <li>작성하신 리뷰 및 평점 삭제</li>
            <li>다시 가입 시 이전 데이터 복구 불가</li>
        </ul>
    </div>

    <form method="get" action="delete_account_reason.php">
        <button type="submit" name="confirm_delete" class="btn-delete">탈퇴하기</button>
        <button type="button" class="btn-cancel" onclick="location.href='mypage.php'">계속 이용하기</button>
    </form>
</div>
</body>
</html>
