<?php
require_once "../includes/db_connect.php";
require_once "../includes/islogin.php";

$response = ['success' => false, 'isFavorited' => false, 'message' => ''];

// 1. 사용자 로그인 상태 확인
if (!isset($_SESSION['user_id'])) {
    $response['success'] = true;
    $response['isFavorited'] = false;
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
$userId = $_SESSION['user_id'];

// 2. JavaScript로부터 GET 방식으로 전달된 레스토랑 ID 확인 및 유효성 검사
if (!isset($_GET['restaurant_id']) || !filter_var($_GET['restaurant_id'], FILTER_VALIDATE_INT)) {
    $response['message'] = '잘못된 레스토랑 ID가 전달되었습니다.';
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
$restaurantId = (int)$_GET['restaurant_id'];

// 3. 데이터베이스 연결 확인 (db_connect.php 에서 생성된 $conn 변수 사용)
if ($conn->connect_error) {
    $response['message'] = '데이터베이스 서버에 연결할 수 없습니다.';
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// 4. User_favorites 테이블에서 해당 사용자와 레스토랑 ID 조합이 있는지 확인
$isFavoritedResult = false;
$sql = "SELECT COUNT(*) FROM User_favorites WHERE user_id = ? AND restaurant_id = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ii", $userId, $restaurantId);
    
    if ($stmt->execute()) {
        $stmt->bind_result($count);
        if ($stmt->fetch()) {
            if ($count > 0) {
                $isFavoritedResult = true;
            }
            $response['success'] = true;
            $response['isFavorited'] = $isFavoritedResult; 
        } else {
             $response['message'] = '찜 상태를 가져오는 데 실패했습니다. (fetch)';
        }
    } else {
        $response['message'] = '찜 상태를 조회하는 중 오류가 발생했습니다. (execute)';

    }
    $stmt->close();
} else {
    $response['message'] = '데이터베이스 쿼리 준비 중 오류가 발생했습니다.';
}

// 5. DB 연결 종료
$conn->close();

// 6. 최종 결과를 JSON 형식으로 출력
header('Content-Type: application/json');
echo json_encode($response);
?>