<?php
session_start();
require '../includes/db_connect.php'; 

if (!isset($_SESSION['user_id'])) {
    $_SESSION['cart_message'] = ['type' => 'error', 'text' => '장바구니를 사용하려면 로그인이 필요합니다.'];
    // 원래 돌아갈 페이지를 결정
    $redirect_target = '../pages/menu/menulist.php';
    if (isset($_GET['restaurant_id']) && (int)$_GET['restaurant_id'] > 0) {
        $redirect_target .= '?restaurant_id=' . (int)$_GET['restaurant_id'];
    } elseif (isset($_SERVER['HTTP_REFERER'])) {
        $redirect_target = $_SERVER['HTTP_REFERER'];
    }

    // 로그인 페이지로 이동하면서 원래 페이지를 리디렉션 파라미터로 넘김
    $login_page_url = 'login.php';
    $encoded_redirect_target = urlencode($redirect_target);
    header("Location: " . $login_page_url . "?redirect=" . $encoded_redirect_target);
    exit;
}
$user_id = (int)$_SESSION['user_id'];


$food_id = isset($_POST['food_id']) ? filter_var($_POST['food_id'], FILTER_VALIDATE_INT) : null;
$restaurant_id_for_redirect = isset($_POST['restaurant_id']) ? filter_var($_POST['restaurant_id'], FILTER_VALIDATE_INT) : null;


if ($food_id && $food_id > 0) {
    // 장바구니에 이미 있는지 확인
    $check_sql = "SELECT quantity FROM Cart WHERE user_id = ? AND food_id = ?";
    $stmt = $conn->prepare($check_sql);
    if ($stmt) {
        $stmt->bind_param("ii", $user_id, $food_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // 이미 있으면 수량 +1
            $update_sql = "UPDATE Cart SET quantity = quantity + 1 WHERE user_id = ? AND food_id = ?";
            $update_stmt = $conn->prepare($update_sql);
            if ($update_stmt) {
                $update_stmt->bind_param("ii", $user_id, $food_id);
                $update_stmt->execute();
                // 성공/실패 메시지 세션에 저장 (선택 사항)
                if ($update_stmt->affected_rows > 0) {
                     $_SESSION['cart_action_message'] = ['type' => 'success', 'text' => '상품 수량을 추가했습니다.'];
                } else {
                     $_SESSION['cart_action_message'] = ['type' => 'info', 'text' => '수량 변경 없음 (또는 오류).'];
                }
                $update_stmt->close();
            } else {
                error_log("add_to_cart.php: Cart update prepare failed - " . $conn->error);
                $_SESSION['cart_action_message'] = ['type' => 'error', 'text' => '장바구니 업데이트 중 오류가 발생했습니다.'];
            }
        } else {
            // 없으면 새로 추가
            $insert_sql = "INSERT INTO Cart (user_id, food_id, quantity, added_at) VALUES (?, ?, 1, NOW())";
            $insert_stmt = $conn->prepare($insert_sql);
            if ($insert_stmt) {
                $insert_stmt->bind_param("ii", $user_id, $food_id);
                $insert_stmt->execute();
                if ($insert_stmt->affected_rows > 0) {
                    $_SESSION['cart_action_message'] = ['type' => 'success', 'text' => '장바구니에 상품을 담았습니다.'];
                } else {
                    $_SESSION['cart_action_message'] = ['type' => 'error', 'text' => '장바구니에 상품을 담는데 실패했습니다.'];
                }
                $insert_stmt->close();
            } else {
                error_log("add_to_cart.php: Cart insert prepare failed - " . $conn->error);
                $_SESSION['cart_action_message'] = ['type' => 'error', 'text' => '장바구니 추가 중 오류가 발생했습니다.'];
            }
        }
        $stmt->close();
    } else {
        error_log("add_to_cart.php: Cart check prepare failed - " . $conn->error);
        $_SESSION['cart_action_message'] = ['type' => 'error', 'text' => '장바구니 확인 중 오류가 발생했습니다.'];
    }
} else {
    $_SESSION['cart_action_message'] = ['type' => 'error', 'text' => '잘못된 상품 ID입니다.'];
}

// 리디렉션 URL 결정
$redirect_url = '../pages/menu/menulist.php';

if ($restaurant_id_for_redirect && $restaurant_id_for_redirect > 0) {
    $redirect_url .= '?restaurant_id=' . $restaurant_id_for_redirect;
} elseif (isset($_SERVER['HTTP_REFERER'])) { 
    $redirect_url = $_SERVER['HTTP_REFERER'];
}


header("Location: " . $redirect_url);
$conn->close();
exit;
?>