<?php
session_start();
require_once "../includes/islogin.php"; // 로그인 여부 확인 및 $user_id 설정
require_once "../includes/db_connect.php";

header('Content-Type: application/json');

// 현재 로그인된 사용자 ID가 없으면 실패
if (!isset($user_id)) {
    echo json_encode([
        "success" => false,
        "message" => "로그인이 필요합니다."
    ]);
    exit;
}

// 사용자 설정 조회
$sql = "SELECT notifications_enabled, auto_login_enabled FROM UserAppSettings WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        "success" => true,
        "settings" => [
            "notifications_enabled" => (bool)$row['notifications_enabled'],
            "auto_login_enabled" => (bool)$row['auto_login_enabled']
        ]
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "설정값이 존재하지 않습니다."
    ]);
}
?>
