<?php
require_once "../includes/islogin.php";
require_once '../includes/db_connect.php';


$user_id = $_SESSION['user_id'];
$notifications = false;
$auto_login = false;

// POST 요청 시 설정 저장 처리
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $notifications = isset($_POST['notifications']) ? 1 : 0;
    $auto_login = isset($_POST['auto_login']) ? 1 : 0;

    // 이미 설정이 존재하는지 확인
    $check_sql = "SELECT setting_id FROM UserAppSettings WHERE user_id = ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        // 기존 설정 업데이트
        $update_sql = "UPDATE UserAppSettings SET notifications_enabled = ?, auto_login_enabled = ?, updated_at = NOW() WHERE user_id = ?";
        $update_stmt = $conn->prepare($update_sql);
        $update_stmt->bind_param("iii", $notifications, $auto_login, $user_id);
        $update_stmt->execute();
    } else {
        // 새 설정 추가
        $insert_sql = "INSERT INTO UserAppSettings (user_id, notifications_enabled, auto_login_enabled, updated_at) VALUES (?, ?, ?, NOW())";
        $insert_stmt = $conn->prepare($insert_sql);
        $insert_stmt->bind_param("iii", $user_id, $notifications, $auto_login);
        $insert_stmt->execute();
    }
}

// 현재 설정값 불러오기
$fetch_sql = "SELECT notifications_enabled, auto_login_enabled FROM UserAppSettings WHERE user_id = ?";
$fetch_stmt = $conn->prepare($fetch_sql);
$fetch_stmt->bind_param("i", $user_id);
$fetch_stmt->execute();
$result = $fetch_stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $notifications = (bool)$row['notifications_enabled'];
    $auto_login = (bool)$row['auto_login_enabled'];
}
?>
<!DOCTYPE html>
<html lang="ko">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>앱 설정</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        html,
        body {
            height: 100%;
            margin: 0;
            font-family: sans-serif;
            background-color: #f4f4f4;
        }

        .container {
            height: 100%;
            max-width: 400px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0 15px;
            height: 70px;
            box-sizing: border-box;
            border-bottom: 1px solid #eee;
        }

        .header h1 {
            font-size: 1.2em;
            margin: 0;
            display: flex;
            align-items: center;
        }

        .header-logo-img {
            height: 50px;
            width: auto;
            margin-right: 8px;
        }

        .content {
            flex: 1;
            padding: 20px;
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .setting-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .setting-row label {
            font-size: 1em;
            color: #333;
        }

        .setting-row input[type="checkbox"] {
            transform: scale(1.3);
        }

        .save-btn {
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1em;
            cursor: pointer;
        }

        .save-btn:hover {
            background-color: #0056b3;
        }

        .content-wrapper {
            flex: 1;
            padding: 20px;
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .setting-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .setting-row label {
            font-size: 1em;
            color: #333;
        }

        .setting-row input[type="checkbox"] {
            transform: scale(1.3);
        }

        .fixed-footer {
            padding: 12px;
            background-color: white;
            border-top: 1px solid #ddd;
            box-shadow: 0 -1px 5px rgba(0, 0, 0, 0.05);
        }

        .save-btn {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1em;
            cursor: pointer;
        }

        .save-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
    <div class="container">
        <header class="header">
            <h1>앱 설정</h1>
        </header>

        <form method="POST" action="appSettings.php" style="flex: 1; display: flex; flex-direction: column;">
            <div class="content-wrapper">
                <div class="setting-row">
                    <label for="notifications">알림 받기</label>
                    <input type="checkbox" id="notifications" name="notifications" <?php echo $notifications ? 'checked'
                        : '' ; ?>>
                </div>
                <div class="setting-row">
                    <label for="auto_login">자동 로그인</label>
                    <input type="checkbox" id="auto_login" name="auto_login" <?php echo $auto_login ? 'checked' : '' ;
                        ?>>
                </div>
            </div>
            <div class="fixed-footer">
                <button type="submit" class="save-btn">설정 저장</button>
            </div>
        </form>

    </div>
</body>

</html>