<?php
require_once '../includes/db_connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'];
  $location = $_POST['location'];
  $phone = $_POST['phone'];
  $opening_hours = $_POST['opening_hours'];
  $image_url = $_POST['image_url'];
  $description = $_POST['description'];
  $hygiene_certification = $_POST['hygiene_certification'];
  $disinfection_certification = $_POST['disinfection_certification'];
  $origin_certification = $_POST['origin_certification'];
  $awards = $_POST['awards'];
  $representative_name = $_POST['representative_name'];
  $business_number = $_POST['business_number'];
  $business_address = $_POST['business_address'];

  $stmt = $conn->prepare("INSERT INTO Restaurants (name, location, phone, opening_hours, image_url) VALUES (?, ?, ?, ?, ?)");
  $stmt->bind_param("sssss", $name, $location, $phone, $opening_hours, $image_url);
  $stmt->execute();
  $restaurant_id = $stmt->insert_id;

  $stmt2 = $conn->prepare("INSERT INTO Restaurants_info (restaurant_id, description, hygiene_certification, disinfection_certification, origin_certification, awards, representative_name, business_number, business_address) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $stmt2->bind_param("issssssss", $restaurant_id, $description, $hygiene_certification, $disinfection_certification, $origin_certification, $awards, $representative_name, $business_number, $business_address);
  $stmt2->execute();

  echo "<script>alert('가게가 성공적으로 등록되었습니다!'); location.href='store-detail.php?id={$restaurant_id}';</script>";
}
?>

<!DOCTYPE html>
<html lang="ko">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>가게 등록</title>
  <link rel="stylesheet" href="/css/style_main.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <style>
  html, body {
    height: 100%;
    margin: 0;
    font-family: sans-serif;
    background-color: #f4f4f4;
  }

  .container {
    height: 100%;
    max-width: 400px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    background-color: white;
    border: 1px solid #e0e0e0;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
  }

  .header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 15px;
    height: 70px;
    box-sizing: border-box;
  }

  .header h1 {
    display: flex;
    align-items: center;
    font-size: 1.2em;
    margin: 0;
    flex-grow: 1;
    justify-content: center;
  }

  .header-logo-img {
    height: 70px;
    width: auto;
  }

  .form-container {
    flex: 1;
    overflow-y: auto;
    padding: 20px 15px;
  }

  .form-container h2 {
    font-size: 1.1em;
    margin-top: 20px;
    border-bottom: 1px solid #ddd;
    padding-bottom: 5px;
  }

  .form-group {
    margin: 15px 0;
  }

  .form-group label {
    display: block;
    font-size: 0.95em;
    margin-bottom: 5px;
    color: #333;
  }

  .form-group input,
  .form-group textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 0.95em;
    background-color: #f9f9f9;
    box-sizing: border-box;
  }

  button[type="submit"] {
    width: 100%;
    padding: 12px;
    background-color: #007bff;
    color: white;
    font-size: 1em;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    margin-top: 25px;
  }

  button[type="submit"]:hover {
    background-color: #0056b3;
  }

  .bottom-nav {
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 10px 0;
    border-top: 1px solid #eee;
    background-color: white;
    flex-shrink: 0;
  }

  .bottom-nav a {
    color: #555;
    font-size: 1.5em;
    text-decoration: none;
    padding: 5px 10px;
    transition: color 0.2s;
  }

  .bottom-nav a:hover,
  .bottom-nav a.active {
    color: #007bff;
  }
</style>


</head>

<body>
  <div class="container">
    <!-- 헤더 -->
    <header class="header">
      <h1>
        <img src="../assets/images/임시로고.jpg" alt="로고" class="header-logo-img" />
        <span>가게 등록</span>
      </h1>
    </header>

    <!-- 본문: 가게 등록 폼 -->
    <div class="form-container">
      <form method="post">
        <h2>기본 정보</h2>
        <div class="form-group"><label>식당 이름</label><input type="text" name="name" required /></div>
        <div class="form-group"><label>위치</label><input type="text" name="location" required /></div>
        <div class="form-group"><label>전화번호</label><input type="text" name="phone" required /></div>
        <div class="form-group"><label>영업 시간</label><input type="text" name="opening_hours" /></div>
        <div class="form-group"><label>이미지 URL</label><input type="text" name="image_url" /></div>

        <h2>가게 소개 및 인증</h2>
        <div class="form-group"><label>가게 소개</label><textarea name="description" rows="3"></textarea></div>
        <div class="form-group"><label>위생 인증</label><input type="text" name="hygiene_certification" /></div>
        <div class="form-group"><label>소독 인증</label><input type="text" name="disinfection_certification" /></div>
        <div class="form-group"><label>원산지 인증</label><input type="text" name="origin_certification" /></div>
        <div class="form-group"><label>수상 경력</label><input type="text" name="awards" /></div>

        <h2>사업자 정보</h2>
        <div class="form-group"><label>대표자명</label><input type="text" name="representative_name" /></div>
        <div class="form-group"><label>사업자 등록번호</label><input type="text" name="business_number" /></div>
        <div class="form-group"><label>사업자 주소</label><input type="text" name="business_address" /></div>

        <button type="submit">가게 등록</button>
      </form>
    </div>

    <!-- 하단 네비게이션 -->
    <nav class="bottom-nav">
      <a href="../main.php" class="active"><i class="fas fa-home"></i></a>
      <a href="dibs.php"><i class="fas fa-heart"></i></a>
      <a href="orderlist.php"><i class="fas fa-receipt"></i></a>
      <a href="../../auth/redirect-mypage.php"><i class="fas fa-user"></i></a>
    </nav>
  </div>
</body>

</html>
