<?php
require_once('../../includes/db_connect.php');

// 예약 전체 목록 불러오기
$sql = "SELECT R.reservation_id, R.user_id, R.reservation_time, R.food_id, R.status,
               U.username, F.name AS food_name
        FROM Reservations R
        JOIN Users U ON R.user_id = U.user_id
        JOIN Foods F ON R.food_id = F.food_id
        ORDER BY R.reservation_time DESC";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <title>예약 관리</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            margin: 0;
            background-color: #f8f8f8;
            font-family: sans-serif;
        }

        .container {
            display: flex;
            flex-direction: column;
            height: 100vh;
            max-width: 400px;
            margin: 0 auto;
            background-color: white;
            padding-bottom: 60px; /* 네비게이션 높이만큼 */
        }



        h1 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        th, td {
            border-bottom: 1px solid #ccc;
            padding: 8px;
            text-align: center;
        }

        select, button {
            font-size: 13px;
            padding: 4px 6px;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 400px;
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #ddd;
            background-color: #fff;
            z-index: 999;
        }



        .bottom-nav a {
            color: #555;
            font-size: 1.5em;
            text-decoration: none;
        }

        .bottom-nav a.active,
        .bottom-nav a:hover {
            color: #007bff;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>예약 관리</h1>
    <table>
        <thead>
            <tr>
                <th>사용자</th>
                <th>예약시간</th>
                <th>음식</th>
                <th>상태</th>
                <th>변경</th>
            </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= $row['reservation_id'] ?></td>
                <td><?= htmlspecialchars($row['username']) ?></td>
                <td><?= $row['reservation_time'] ?></td>
                <td><?= htmlspecialchars($row['food_name']) ?></td>
                <td><?= htmlspecialchars($row['status']) ?></td>
                <td>
                    <form action="update_reservation_status.php" method="POST">
                        <input type="hidden" name="reservation_id" value="<?= $row['reservation_id'] ?>">
                        <select name="status">
                            <option value="대기" <?= $row['status'] == '대기' ? 'selected' : '' ?>>대기</option>
                            <option value="확정" <?= $row['status'] == '확정' ? 'selected' : '' ?>>확정</option>
                            <option value="취소" <?= $row['status'] == '취소' ? 'selected' : '' ?>>취소</option>
                        </select>
                        <button type="submit">변경</button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- 하단 네비게이션 -->
<nav class="bottom-nav">
    <a href="../main.php" class="active" title="홈"><i class="fa-solid fa-house"></i></a>
    <a href="../order/orderlist.php" title="주문 목록"><i class="fa-solid fa-receipt"></i></a>
    <a href="../mypage.php" title="마이페이지"><i class="fa-solid fa-user"></i></a>
</nav>
</body>
</html>
