<?php
session_start();
require_once '../includes/db_connect.php';  // DB 연결
require_once '../includes/islogin.php';     // 로그인 체크

$user_id = $_SESSION['user_id'] ?? null;

if (!$user_id) {
    echo "<script>alert('로그인이 필요합니다.'); location.href='/login.php';</script>";
    exit;
}

$current_password = $_POST['current_password'] ?? '';
$new_password = $_POST['new_password'] ?? '';
$confirm_password = $_POST['confirm_password'] ?? '';

if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
    echo "<script>alert('모든 필드를 입력해주세요.'); history.back();</script>";
    exit;
}

// DB에서 현재 비밀번호 해시 가져오기
$sql = "SELECT password FROM Users WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($db_password_hash);
$stmt->fetch();
$stmt->close();

// 현재 비밀번호 검증
if (!password_verify($current_password, $db_password_hash)) {
    echo "<script>alert('현재 비밀번호가 올바르지 않습니다.'); history.back();</script>";
    exit;
}

// 새 비밀번호와 확인 비밀번호 일치 여부 확인
if ($new_password !== $confirm_password) {
    echo "<script>alert('새 비밀번호가 일치하지 않습니다.'); history.back();</script>";
    exit;
}

// 새 비밀번호 해시 생성
$new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);

// DB에 새 비밀번호 업데이트
$sql = "UPDATE Users SET password = ? WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $new_password_hash, $user_id);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    echo "<script>alert('비밀번호가 성공적으로 변경되었습니다.'); location.href='/Capstone/pages/user/mypage.php'; </script>";
} else {
    echo "<script>alert('비밀번호 변경에 실패했습니다.'); history.back();</script>";
}

$stmt->close();
$conn->close();
?>
