<?php
session_start();
require_once '../includes/islogin.php'; // 로그인 체크
?>

<!DOCTYPE html>
<html lang="ko">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>비밀번호 변경</title>
  <style>
    /* 모바일에 최적화된 심플 스타일 */
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
      max-width: 400px;
      margin: 0 auto;
      background: #f9f9f9;
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }
    form {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 8px rgba(0,0,0,0.1);
    }
    label {
      display: block;
      margin-bottom: 6px;
      font-weight: bold;
      color: #555;
    }
    input[type="password"] {
      width: 100%;
      padding: 10px 12px;
      margin-bottom: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      box-sizing: border-box;
      font-size: 16px;
      transition: border-color 0.3s ease;
    }
    input[type="password"]:focus {
      border-color: #007BFF;
      outline: none;
    }
    button {
      width: 100%;
      padding: 12px;
      background-color: #007BFF;
      border: none;
      border-radius: 6px;
      color: white;
      font-size: 18px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }
    button:hover {
      background-color: #0056b3;
    }
    @media (max-width: 480px) {
      body {
        padding: 10px;
      }
      form {
        padding: 15px;
      }
      input[type="password"], button {
        font-size: 16px;
        padding: 10px;
      }
    }
  </style>
</head>
<body>
  <h2>비밀번호 변경</h2>
  <form action="password-change.php" method="POST" autocomplete="off">
    <label for="current_password">현재 비밀번호</label>
    <input type="password" id="current_password" name="current_password" required placeholder="현재 비밀번호 입력" />

    <label for="new_password">새 비밀번호</label>
    <input type="password" id="new_password" name="new_password" required placeholder="새 비밀번호 입력" />

    <label for="confirm_password">새 비밀번호 확인</label>
    <input type="password" id="confirm_password" name="confirm_password" required placeholder="새 비밀번호 다시 입력" />

    <button type="submit">비밀번호 변경</button>
  </form>
</body>
</html>
