<?php
session_start();
require_once('../includes/db_connect.php');

if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    echo '<script>alert("관리자만 접근 가능합니다."); window.location.href = "/Capstone/main.php";</script>';
    exit;
}

$user_id = $_SESSION['user_id'];

// 사용자 정보 불러오기
$sql = "SELECT username, student_id FROM Users WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $student_id);
$stmt->fetch();
$stmt->close();

// 사용하지 않은 쿠폰 수 조회
$sql_coupon = "SELECT COUNT(*) FROM UserCoupons WHERE user_id = ? AND used = 0";
$stmt_coupon = $conn->prepare($sql_coupon);
$stmt_coupon->bind_param("i", $user_id);
$stmt_coupon->execute();
$stmt_coupon->bind_result($coupon_count);
$stmt_coupon->fetch();
$stmt_coupon->close();
?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8" />
    <title>마이페이지</title>
    <link 
      rel="stylesheet" 
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" 
      integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" 
      crossorigin="anonymous" 
      referrerpolicy="no-referrer" 
    />
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            font-family: sans-serif;
            display: flex;
            justify-content: center;
            height: 100vh;
            overflow: hidden;
        }

        .container {
            width: 100%;
            max-width: 420px;
            height: 100vh;
            background-color: white;
            border: 1px solid #e0e0e0;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            box-sizing: border-box;
            position: relative;
        }

        /* 완전 고정 헤더 */
        .header-fixed {
            position: fixed;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 420px;
            background-color: white;
            z-index: 1001;
            padding: 30px 20px 10px;
            text-align: center;
            box-sizing: border-box;
            border-bottom: 1px solid #ccc;
        }

        .header-fixed h2 {
            margin: 0;
            font-size: 24px;
        }

        .header-fixed .student {
            color: gray;
            margin-top: 5px;
            font-size: 14px;
        }

        /* 헤더 높이만큼 패딩 추가 */
        .mypage {
            flex-grow: 1;
            overflow-y: auto;
            padding: 90px 20px 80px; /* 위쪽 패딩은 헤더 높이만큼 */
            box-sizing: border-box;
        }

        .mypage hr {
            margin: 10px auto 20px;
            border: none;
            border-top: 1px solid #ccc;
            max-width: 380px;
        }

        .mypage ul {
            list-style: none;
            padding: 0;
            margin: 0;
            text-align: left;
        }

        .mypage li {
            margin: 30px 0;
            font-size: 19px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .mypage li a {
            color: black;
            text-decoration: none;
            flex-grow: 1;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .mypage li .count {
            color: #007bff;
            font-weight: bold;
            min-width: 20px;
            text-align: right;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 420px;
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 10px 0;
            border-top: 1px solid #eee;
            background-color: white;
            box-sizing: border-box;
            z-index: 1000;
        }

        .bottom-nav a {
            color: #555;
            font-size: 1.5em;
            text-decoration: none;
            padding: 5px 10px;
            transition: color 0.2s;
        }

        .bottom-nav a:hover,
        .bottom-nav a.active {
            color: #007bff;
        }

    </style>

    <script>
        function logoutConfirm() {
            if (confirm("로그아웃 하시겠습니까?")) {
                location.href = '../auth/logout.php';
            }
        }
    </script>
</head>
<body>
    <div class="container">
    <div class="header-fixed">
      <h2><?= htmlspecialchars($username) ?></h2>
      <div class="student"><?= htmlspecialchars($student_id) ?></div>
      <hr>
    </div>
        <div class="mypage">
            
            <ul>
                <li><a href="../admin/store/store_create.php"><i class="fa-solid fa-store"></i>가게 등록</a></li>
                <li><a href="#"><i class="fa-solid fa-store"></i>가게 수정</a></li>
                <li><a href="../admin/order/orderprogress.html"><i class="fa-solid fa-clock"></i>현재 주문</a></li>
                <li><a href="../admin/order/orderlist.html"><i class="fa-solid fa-list-check"></i>주문 관리</a></li>
                <li><a href="../admin/menu/menuadd.html"><i class="fa-solid fa-plus"></i>메뉴 추가</a></li>
                <li><a href="../admin/menu/menulist.html"><i class="fa-solid fa-bars"></i>메뉴 관리</a></li>
                <li><a href="reservation/res_manage.php"><i class="fa-solid fa-calendar-check"></i>예약 관리</a></li>
                <li><a href="#"><i class="fa-solid fa-chair"></i>좌석 관리</a></li>
                <li><a href="../admin/coupon/couponManage.html"><i class="fa-solid fa-ticket"></i>쿠폰 등록</a></li>
                <li><a href="../admin/review/reviewAnswer.html"><i class="fa-solid fa-comment-dots"></i>리뷰 관리</a></li>
                <li><a href="../admin/sales/saleshistory.html"><i class="fa-solid fa-chart-line"></i>매출 관리</a></li>
                <li><a href="../app/appSettings.php"><i class="fa-solid fa-gear"></i>설정</a></li>
                <li><a href="javascript:void(0);" onclick="logoutConfirm()"><i class="fa-solid fa-right-from-bracket"></i>로그아웃</a></li>
            </ul>
        </div>

        <nav class="bottom-nav">
            <a href="main.php" class="active"><i class="fa-solid fa-house"></i></a>
            <a href="../pages/user/dibs.php"><i class="fa-solid fa-heart"></i></a>
            <a href="../pages/order/orderlist.php"><i class="fa-solid fa-receipt"></i></a>
            <a href="mypage.php"><i class="fa-solid fa-user"></i></a>
        </nav>
    </div>
</body>
</html>
